#ifndef _FILEIO_MMAP_FTHREAD_H
#define _FILEIO_MMAP_FTHREAD_H

#include <vector>
#include <map>
#include <sys/unistd.h>
#include <sys/mman.h>

long int ecasound_fiommap_register_fd(int fd);
void ecasound_fiommap_close_fd(int fd);
void ecasound_fiommap_reset(int fd, long fposition);
unsigned char* ecasound_fiommap_active_buffer(int fd);
void ecasound_fiommap_next_buffer(int fd);
void ecasound_fiommap_exec_thread(void); 
void *ecasound_fiommap_process(void *);

class ECASOUND_FIOMMAP_BUFFER {
 public:

  vector<unsigned char*> buffers;
  vector<unsigned char*>::size_type locked_buffer;
  map<int,bool> ready_for_fill;

  long int mmap_low;
  long int mmap_high;
  long int buffersize;
  int fd;
  bool ready;

  ECASOUND_FIOMMAP_BUFFER(void) {
    locked_buffer = 0;
    mmap_low = -1;
    mmap_high = 0;
    locked_buffer = 0;
    ready = false;
    buffersize = 0;
    buffers.push_back(0);
    buffers[0] = 0;
    buffers.push_back(0);
    buffers[1] = 0;
  }

  ~ECASOUND_FIOMMAP_BUFFER(void) {
    while(buffers.size() > 0) {
      if (buffers.back() != 0) {
	munmap(buffers.back(), buffersize);
	delete buffers.back();
      }
      buffers.pop_back();
    }
  }
};

#endif

