#ifndef _AUDIOIO_AF_H
#define _AUDIOIO_AF_H

#include <config.h>
#ifdef COMPILE_AF

#include <string>
#include <audiofile.h>

class SAMPLE_BUFFER;

#include "audioio.h"
#include "samplebuffer.h"

/**
 * 
 * Interface to SGI audiofile library. 
 * @author Kai Vehmanen
 */
class AUDIOFILE_INTERFACE : public AUDIO_IO_FILE {

    long samples_read;
    AFfilehandle afhandle;

    AUDIOFILE_INTERFACE& operator=(const AUDIOFILE_INTERFACE& x) {
      return *this; }
    void debug_print_type(void);
    void position_in_samples_hook(void);

 public:

    void open_device(void);
    void close_device(void);
    
    void read_buffer(SAMPLE_BUFFER* t);
    void write_buffer(SAMPLE_BUFFER* t);

    AUDIOFILE_INTERFACE* clone(void) { return new AUDIOFILE_INTERFACE(*this); }
    
    AUDIOFILE_INTERFACE (const string& name, const SIMODE mode, const
			 AIO_PARAMS& form, int bsize);
    ~AUDIOFILE_INTERFACE(void);
};

#endif
#endif


