#ifndef _AUDIOIO_OSS_H
#define _AUDIOIO_OSS_H

#include <config.h>
#ifdef COMPILE_OSS

#include <string>

#include <sys/time.h>
#include <sys/types.h>
#include <sys/ioctl.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/soundcard.h>

#include "samplebuffer.h"

/**
 * Class for handling Open Sound System -devices (OSS/Linux 
 * and OSS/Lite).
 * @author Kai Vehmanen
 */
class OSSDEVICE : public AUDIO_IO_DEVICE {

    int audio_fd;

    audio_buf_info audiobuf;          // soundcard.h
    count_info audioinfo;             // soundcard.h
    fd_set fds;
    struct timeval tv;
    int fragment_size;
    long int bytes_read;

    bool is_triggered;

    public:

    void read_buffer(SAMPLE_BUFFER* t);
    void write_buffer(SAMPLE_BUFFER* t);

    void open_device(void);
    void close_device(void);
    
    // --
    // Realtime related functions
    // --
    
    void rt_stop(void);
    void rt_ready(void);
    void rt_activate(void);

    OSSDEVICE (const string& name, const SIMODE mode, const AIO_PARAMS& form, int buffersize);
    ~OSSDEVICE(void);
    //    OSSDEVICE* new_expr(void) { return new OSSDEVICE(); }
    OSSDEVICE* clone(void) { return new OSSDEVICE(*this); }

 private:

    OSSDEVICE(const OSSDEVICE& x) { }
    OSSDEVICE& operator=(const OSSDEVICE& x) { return *this; }    

};

#endif // COMPILE_OSS
#endif
