#ifndef _AUDIOIO_AF_H
#define _AUDIOIO_AF_H

#include <config.h>
#ifdef COMPILE_AF

#include <string>
#include <audiofile.h>

#include "audioio.h"
#include "samplebuffer.h"

class AUDIOFILE_INTERFACE : public AUDIO_IO_DEVICE {
//
// Interface to SGI audiofile library. 
//

    long samples_read;
    AFfilehandle afhandle;

    AUDIOFILE_INTERFACE& operator=(const AUDIOFILE_INTERFACE& x) {
      return *this; }
    void debug_print_type(void);
    void position_in_samples_hook(void);

 public:

    void open_device(void);
    void close_device(void);
    
    void   get_sample(SAMPLE_BUFFER* t);
    void   put_sample(SAMPLE_BUFFER* t);

    inline bool is_realtime(void) const { return(false); }
    
    AUDIOFILE_INTERFACE* clone(void) { return new AUDIOFILE_INTERFACE(*this); }
    
    AUDIOFILE_INTERFACE (const string& name, const SIMODE mode, const
			 AIO_PARAMS& form, int bsize);
    ~AUDIOFILE_INTERFACE(void);
};

#endif
#endif


