#ifndef _AUDIOFX_TIMEBASED_H
#define _AUDIOFX_TIMEBASED_H

#include <vector>
// #include <deque>
#include <string>

#include "audiofx.h"

typedef deque<SAMPLE_BUFFER::sample_type> SINGLE_BUFFER;
// typedef vector<SAMPLE_BUFFER::sample_type> SINGLE_BUFFER;

class EFFECT_TIME_BASED : public AUDIOFX_BASE {
  //
  // Base class for time-based effects (delays, reverbs, etc).
  //
 protected:
    
  double dtime;        // delay time in samples
  double laskuri;
  
 public:

  virtual EFFECT_TIME_BASED* clone(void) = 0;
  EFFECT_TIME_BASED(void) { support_for_dynamic_parameters(false); }
};

class EFFECT_DELAY : public EFFECT_TIME_BASED {
  //
  // Delay effect.
  //
private:

    SAMPLE_BUFFER::sample_type temp, temp2;     // temporary values
    int nm2; // temp-value

    double surround;
    double dnum;
    double mix;

    vector<SINGLE_BUFFER> buffer;

public:

    string label(void) { return("Delay"); }
    string id_string(void) { return("etd"); }
    double get_parameter(int param);

    void process(SAMPLE_BUFFER::sample_type *insample);
    double get_delta_in_samples(void) { return(dnum * dtime); }

    EFFECT_DELAY* clone(void)  { return new EFFECT_DELAY(*this); }
    EFFECT_DELAY (double delay_time, int surround_mode, int num_of_delays, double mix_percent);
};

class EFFECT_FAKE_STEREO : public EFFECT_TIME_BASED {
  //
  // Transforms a mono signal to stereo using a panned delay signal.
  // Suitable delays values range from 1 to 40 milliseconds. 
  //

  SAMPLE_BUFFER::sample_type temp;   // temp-values
  vector<SINGLE_BUFFER> buffer;

public:

    string label(void) { return("Fake stereo"); }
    string id_string(void) { return("etf"); }
    double get_parameter(int param);
    void process(SAMPLE_BUFFER::sample_type *insample);

    EFFECT_FAKE_STEREO* clone(void)  { return new EFFECT_FAKE_STEREO(*this); }
    EFFECT_FAKE_STEREO::EFFECT_FAKE_STEREO (double delay_time);
};

class EFFECT_REVERB : public EFFECT_TIME_BASED {
  //
  // A reverb effect.
  //

private:
    
  SAMPLE_BUFFER::sample_type temp;  // temp-values
  //  typedef RING_BUFFER<SAMPLE_BUFFER::sample_type> FSINGLE_BUFFER;
  
  vector<SINGLE_BUFFER> buffer;

  double surround;
  double feedback;

 public:

  string label(void) { return("Reverb"); }
  string id_string(void) { return("etr"); }
  double get_parameter(int param);
  void process(SAMPLE_BUFFER::sample_type *insample);
  double get_delta_in_samples(void) { return(dtime); }

  EFFECT_REVERB* clone(void)  { return new EFFECT_REVERB(*this); }
  EFFECT_REVERB (double delay_time, int surround_mode, double feedback_percent);
};

#endif


