#ifndef _ECA_QT_WAVEFORM_H
#define _ECA_QT_WAVEFORM_H

#include <vector>
#include <qwidget.h>
#include <qlayout.h>

#include "eca-qtwavedata.h"
#include "audioio.h"
#include "samplebuffer.h"

class QEWaveForm : public QWidget
{
  Q_OBJECT
public:
  QEWaveForm(AUDIO_IO_DEVICE* iodevice, QWidget *parent=0, const char *name=0 );

signals:
  void setTotalSteps (int totalSteps);
  void setProgress (int progress);

public slots:
  void updateWaveData(void);
  void updateWaveView(void);

protected:

  void init_buttons(); 
  void init_shortcuts();

private:

  QBoxLayout* topLayout;
  QBoxLayout* buttons;

  QEWaveData* wdata;
  bool valid_iodevice;
};


#endif


