#ifndef _ECA_QT_WAVEDATA_H
#define _ECA_QT_WAVEDATA_H

#include <vector>
#include <qwidget.h>
#include <qpainter.h>
#include <qpixmap.h>

#include "audioio.h"
#include "samplebuffer.h"

class QEWaveBlock {
 public:
  short signed int min[SAMPLE_BUFFER::ch_count];
  short signed int max[SAMPLE_BUFFER::ch_count];
};

class QEWaveData : public QWidget
{
public:
  QEWaveData(AUDIO_IO_DEVICE* iodevice, QWidget *parent=0, const char *name=0 );
  static const int buffersize = 256;

  void updateWaveData(void);
  bool is_valid(void) { return(valid_iodevice); }

protected:

  void paintEvent( QPaintEvent * );
  void timerEvent( QTimerEvent * );

private:

  QRect ur;
  QPixmap pix;
  QPainter p;

  AUDIO_IO_DEVICE* iodevice;
  int samples_per_pixel;
  int xposcoord, newxposcoord;
  int step;
  vector<QEWaveBlock>::size_type t;
  int xcoord;
  int ycoord;
  int waveheight;
  int buffersize_save;

  bool valid_iodevice;
  vector<QEWaveBlock> waveblocks; 
};

#endif


