#ifndef _ECA_CONTROLLER_H
#define _ECA_CONTROLLER_H

#include <pthread.h>

#include "eca-session.h"

#define ECASOUND_LOCK_FILE "/var/lock/ecasound.lck"

enum {
  ECA_QUIT = 1
};

class ECA_CONTROLLER {

  ECA_SESSION* session; 
  int retcode;
  pthread_t th_cqueue;
  bool show_prompt;

 public:

  // ---
  // Status
  // ---
  bool prompt(void);

  // ---
  // CLI
  // ---
  void command(const string& cmd);

  // ---
  // Runtime control
  // ---
  void start(void);
  void stop(void);
  void close_engine(void);
  void start_engine(bool ignore_lock = false);
  void quit(void);
  
  // ---
  // Session info / output to ecadebug
  // ---
  void print_general_status(void);
  void print_chain_status(void);
  void print_effect_status(void);
  void print_file_status(void);

  // ---
  // Session info / functions
  // ---
  string connected_chains_input(CHAIN::aio_id_type aiod);
  string connected_chains_output(CHAIN::aio_id_type aiod);

  // ---
  // Session info / master input
  // ---
  long length_in_samples(void) const { return session->length_in_samples(); }
  double length_in_seconds_exact(void) const { return session->length_in_seconds_exact(); }
  long position_in_samples(void) const { return session->position_in_samples(); }
  double position_in_seconds_exact(void) const { return session->position_in_seconds_exact(); }

  // ---
  // Modify session
  // ---
  void enable_mthreaded_use(void) { session->mthreaded_use_of_session = true; } 
  // ---
  // Session status
  // ---
  bool is_running(void);
  string engine_status(void);
  bool is_engine_ready(void);

  // ---
  // Active chainsetup / general
  // ---
  void activate_chainsetup(const string name, bool handle_errors = true);
  void new_chainsetup(const string name);
  void delete_chainsetup(const string name, bool handle_errors = true);
  void load_chainsetup(const string name, bool handle_errors = true);
  void save_chainsetup(const string name, bool handle_errors = true);

  // ---
  // Active chainsetup / locking
  // ---
  AUDIO_IO_DEVICE* lock_audio_device(const string& name);
  void release_audio_device(const string& name);

  ECA_CONTROLLER (ECA_SESSION* psession);
};

void show_controller_help(void);
void show_controller_help_more(void);

void start_normal_thread(ECA_SESSION* param, int retcode, pthread_t* th_cqueue);
void* start_normal(void* param);
void start_normal(ECA_SESSION* param);

#endif

