#ifndef _ECA_ERROR_H
#define _ECA_ERROR_H

#include <string>

class ECA_ERROR {

public:
  
  enum ACTION { stop, retry, notice };
    
private:
  string esection;
  string eerrormsg;
  
  ACTION eaction;

public:

  virtual const string& error_section(void) { return(esection); }
  virtual const string& error_msg(void) { return(eerrormsg); }
  virtual const ACTION& error_action(void) { return(eaction); }
  
  ECA_ERROR(const string& section, const string& errormsg, const ACTION& action) {
    esection = section;
    eerrormsg = errormsg;
    eaction = action;
  }
  ECA_ERROR(const string& section, const string& errormsg) {
    esection = section;
    eerrormsg = errormsg;
    eaction = stop;
  }
  
  virtual ~ECA_ERROR(void) { }
};

#endif
