#ifndef _ECA_QT_WAVEFORM_H
#define _ECA_QT_WAVEFORM_H

#include <vector>
#include <qwidget.h>

#include "audioio.h"
#include "samplebuffer.h"

class QEWaveBlock {
 public:
  short signed int min[SAMPLE_BUFFER::ch_count];
  short signed int max[SAMPLE_BUFFER::ch_count];
};

class QEWaveForm : public QWidget
{
  Q_OBJECT
public:
  QEWaveForm(AUDIO_IO_DEVICE* iodevice, QWidget *parent=0, const char *name=0 );

  static const int buffersize = 256;

signals:
  void setTotalSteps (int totalSteps);
  void setProgress (int progress);

public slots:
  void updateWaveData(void);

protected:

  void paintEvent( QPaintEvent * );
  void timerEvent( QTimerEvent * );

private:

  AUDIO_IO_DEVICE* iodevice;
  int samples_per_pixel;
  int xposcoord, newxposcoord;
  int step;
  vector<QEWaveBlock>::size_type t;
  int xcoord;
  int ycoord;
  int waveheight;
  int buffersize_save;

  bool valid_iodevice;
  vector<QEWaveBlock> waveblocks; 
};


#endif


