#ifndef _AUDIOIO_RAW_H
#define _AUDIOIO_RAW_H

#include <string>
#include "samplebuffer.h"

class RAWFILE : public AUDIO_IO_DEVICE {
  //
  // Represent a raw/headerless audio file. 
  //
  // Sample layout:
  //     - host byte-order for 16bit samples
  //     - for stereo samples, left channels is put first
  //

  long int samples_read, curpos_value;
  long int length_in_bytes_value;

  FILE* fobject;

  void get_length_in_bytes(void);

  RAWFILE(const RAWFILE& x) { }
  RAWFILE& operator=(const RAWFILE& x) { }

 public:

  void   get_sample(SAMPLE_BUFFER* t);
  void   put_sample(SAMPLE_BUFFER* t);
    
  void   first(void);
  void   last(void);

  inline bool is_realtime(void) const { return(false); }

  long length_in_samples(void)  const { return(length_in_bytes_value / format().align); }
  long position_in_samples(void)  const { return(curpos_value / format().align); }
  void   position_in_samples(long pos);

  RAWFILE (const string& name, const SIMODE mode, const AIO_PARAMS& format, int bsize);
  RAWFILE::~RAWFILE(void);
    
  RAWFILE* clone(void) { return new RAWFILE(*this); }    
};

#endif









