#ifndef _OSCILLATOR_H
#define _OSCILLATOR_H

#include <cmath>
#include <string>

#include "ctrl_source.h"

class OSCILLATOR : public CONTROLLER_SOURCE {
  //
  // Represents a general oscillator. Unlike plain controller sources, 
  // oscillators are time-based. 
  //
 public:

  virtual string label(void) = 0;
  virtual double value(void) = 0;

  OSCILLATOR(double step, double freq, double initial_phase = 0) { 
   // -- step = Internal clock is advanced by 'step' seconds everytime 
   //           value() is called.
   // -- freq = oscillator frequency
   // -- initial_phase = initial phase, multiple of pi

    step_ival_value = step;
    freq_value = freq;
    phase_value = initial_phase * M_PI;
  }

 private:
  
  double step_ival_value, freq_value, phase_value;

 protected:

  double phase_offset(void) const { return(phase_value); }  
  double phase_step(void) const { return(step_ival_value); }
  double frequency(void) const { return(freq_value); }
};

#endif


