#ifndef _CHAIN_H
#define _CHAIN_H

#include <string>
#include <vector>

#include "debug.h"
// #include "audioio.h"
#include "gcontroller.h"
#include "chainop.h"
#include "samplebuffer.h"

class CHAIN {

 private:

  string chainname;
  int chainid;
  bool enabled;

  vector<CHAIN_OPERATOR*>::const_iterator chainop_citer;
  vector<CHAIN_OPERATOR*>::size_type chainop_sizet;
  vector<GCONTROLLER*>::size_type gcontroller_sizet;
 
 public:

  // Typedefs for other class to use: 

  typedef int aio_id_type; 

  CHAIN::aio_id_type inputid;
  CHAIN::aio_id_type outputid;
  //  AUDIO_IO_DEVICE* input;
  //  AUDIO_IO_DEVICE* output;

  SAMPLE_BUFFER audioslot;

  vector<CHAIN_OPERATOR*> chainops;
  vector<GCONTROLLER*> gcontrollers;

  bool is_enabled(void) const { return(enabled); }
  void enable(void) { enabled = true; }
  void disable(void) { enabled = false; }

  string cname(void) const { return(chainname); }
  void cname(const string& c) { chainname = c; }

  void chainop_process(void);
  void gcontroller_update(void);

  CHAIN (int bsize, int cid)
    : audioslot(bsize) {
    ecadebug->msg(1, "(chain) constuctor: CHAIN(int,int)");
    chainid = cid; 
    enabled = true;
    inputid = outputid = -1;
  }
  ~CHAIN (void) { 
    for(vector<CHAIN_OPERATOR*>::iterator p = chainops.begin(); p != chainops.end(); p++)
      delete *p;
    for(vector<GCONTROLLER*>::iterator p = gcontrollers.begin(); p != gcontrollers.end(); p++)
      delete *p;
  }

 private:

  CHAIN& operator=(const CHAIN& x);
  CHAIN (const CHAIN& x);
};

#endif










