#ifndef _AUDIOIO_WAVE_H
#define _AUDIOIO_WAVE_H

#include <string>
#include "audioio.h"
#include "samplebuffer.h"

typedef struct {
    unsigned short int format;
    unsigned short int channels;
    unsigned int long srate;
    unsigned int long byte_second;
    unsigned short int align;
    unsigned short int bits;
} RF;

typedef struct {
    char sig[4];
    unsigned long bsize;
} RB;

typedef struct {
    char id[4];
    unsigned long size;
    char wname[4];
} RH;

class WAVEFILE : public AUDIO_IO_DEVICE {
  //
  // Represent a RIFF WAVE -file (.wav)
  //
  // This class currently supports only a limited set of features:
  //     - format 1 sample data: Pulse Code Modulation (PCM) Format
  //         - only 8 and 16 bit data supported
  //         - if 16 bits, least significant byte first as specified
  //           in the stantard
  //     - 
  //

    RH riff_header;
    RF riff_format;

    long int curpos_value, fseek_start_position;
    long int length_in_bytes_value;
    long int samples_read;
    FILE* fobject;
    
 public:

    void   get_sample(SAMPLE_BUFFER* t);
    void   put_sample(SAMPLE_BUFFER* t);
    void   first(void);
    void   last(void);

    inline bool is_realtime(void) const { return(false); }
    
    long   length_in_samples(void) const;
    long   position_in_samples(void) const;
    void   position_in_samples(long pos);
    
    WAVEFILE (const string& name, const SIMODE mode, const AIO_PARAMS& form);
    WAVEFILE::~WAVEFILE(void);
    WAVEFILE* clone(void) { return new WAVEFILE(*this); }    

    private:

    WAVEFILE(const WAVEFILE& x) { cerr << "WAVE construct"; }
    WAVEFILE& operator=(const WAVEFILE& x) {  cerr << "WAVE copy"; }    

    void   update(void);        
    long int get_length_in_bytes(void);
    long int length_in_bytes(void) const;
    long int curpos(void) const;
    long int get_curpos(void);
    void   read_riff_header (void);
    int    next_riff_block(RB *t, unsigned long int *offtmp);
    void   read_riff_fmt(void);
    void   write_riff_header (void);
    void   write_riff_fmt(void);
    void   write_riff_datablock(void);
    void   update_riff_datablock(void);
    signed long int find_block(char* fblock);
};

#endif


