#ifndef _AUDIOIO_OSS_H
#define _AUDIOIO_OSS_H

#include <config.h>
#ifdef COMPILE_OSS

#include <string>

#include <sys/time.h>
#include <sys/types.h>
#include <sys/ioctl.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/soundcard.h>

#include "samplebuffer.h"

class OSSDEVICE : public AUDIO_IO_DEVICE {
//
// Class for handling OSS -devices (Open Sound System/Linux).
//
// ---
//    long int curpos_value;
//    long int length_in_bytes_value;
//    int	samples;	// number of samples written

    int audio_fd;

    audio_buf_info audiobuf;          // soundcard.h
    count_info audioinfo;             // soundcard.h
    fd_set fds;
    struct timeval tv;
    int fragment_size;

    bool is_open;
    bool is_triggered;
    int buffersize;
    
    void open_device(void);
    void close_device(void);
    
    public:

    void   get_sample(SAMPLE_BUFFER* t);
    void   put_sample(SAMPLE_BUFFER* t);
    
    void first(void) { }
    void last(void) { }

    // --
    // Realtime related functions
    // --
    
    inline bool is_realtime(void) const { return(true); }

    void rt_stop(void);
    void rt_ready(void);
    void rt_activate(void);

    long   length_in_samples(void) const { return(0); }
    long   position_in_samples(void) const { return(0); }
    void   position_in_samples(long pos) { }
    
    OSSDEVICE (const string& name, const SIMODE mode, const AIO_PARAMS& form, int buffersize);
    ~OSSDEVICE(void);
    //    OSSDEVICE* new_expr(void) { return new OSSDEVICE(); }
    OSSDEVICE* clone(void) { return new OSSDEVICE(*this); }

 private:

    OSSDEVICE(const OSSDEVICE& x) { }
    OSSDEVICE& operator=(const OSSDEVICE& x) { }    

};

#endif // COMPILE_OSS
#endif
