// ------------------------------------------------------------------------
// eca_resources.cpp: User settings (~/.ecasoundrc)
// Copyright (C) 1999 Kai Vehmanen (kaiv@wakkanet.fi)
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
// ------------------------------------------------------------------------

#include <map>
#include <string>
#include <cstdlib>
#include <fstream>

#include "eca-resources.h"

ECA_RESOURCES::ECA_RESOURCES(void) { set_defaults(); }

string ECA_RESOURCES::resource_file(void) {
  return( string(getenv("HOME")) + "/" + ".ecasoundrc" );
}

void ECA_RESOURCES::load(void) {
  ifstream fin (resource_file().c_str());

  string first, second;

  while(fin >> first) {
    fin >> second; 
    if (!fin.eof()) {
      rcmap[first] = second;
    }
    while(fin.get() != '\n' && !fin.eof());
  }
  fin.close();
}
 
void ECA_RESOURCES::save(void) {
  ofstream fout (resource_file().c_str());

  map<string,string>::const_iterator p = rcmap.begin();
  while(p != rcmap.end()) {
    fout << p->first << " " << p->second << "\n";
    ++p;
  }
  fout.close();

}

void ECA_RESOURCES::set_defaults(void) {
  rcmap["midi-device"] = "/dev/midi";
  rcmap["default-output"] = "/dev/dsp";
  rcmap["default-buffersize"] = "1024";
  rcmap["default-to-interactive-mode"] = "false";
  rcmap["default-to-raisepriority"] = "false";
  rcmap["resource-directory"] = "/etc/ecasound";
  rcmap["resource-file-genosc-envelopes"] = "generic_oscillators";
  rcmap["resource-file-single-effect-presets"] = "singlechain_effect_presets";
  rcmap["resource-file-multi-effect-presets"] = "multichain_effect_presets";
}

string ECA_RESOURCES::resource(const string& tag) {
  return(rcmap[tag]); 
}

void ECA_RESOURCES::resource(const string& tag, const string& value) {
  rcmap[tag] = value;
}
