.TH "ecasound" "1" "12\&.07\&.1999" "" "Multimedia software" 
.PP 
.SH "NAME" 
ecasound \- sample editor, multitrack recorder, fx-processor, etc\&.
.PP 
.SH "SYNOPSIS" 
\fBecasound\fP [ general_options ] { [ chain_setup ] [ effect_setup ] [ input_setup ] [ output_setup ] }
.PP 
.SH "DESCRIPTION" 
.PP 
Ecasound is a text-mode sound processing program that can do
various tasks from basic editing and effect processing to multitrack
recording\&. Although the user interface may seem a bit cryptic, one of
the main design goals of this project has been to create an
easy-to-use, creative utility for recording and mixing purposes\&.
Because of the simple interface, batch files can be used to automate
complex editing tasks\&. 
.PP 
.SH "OPTIONS" 
.PP 
Notice that the order of parameters given on the command
line is important!
.PP 
\fBGENERAL OPTIONS\fP
.IP 
.IP "-b:buffer size" 
Sets the size of buffer in samples (must be an exponent of 2)\&. This
is quite an important option\&. For real-time processing, you should
set this as low as possible to reduce the processing delay\&. Some
machines can handle buffer values as low as 64 and 128\&. In some
circumstances (for instance when using oscillator envelopes) small
buffer sizes will make envelopes act more smoothly\&. When not processing
in real-time (all inputs and outputs are normal files), values between
512 - 4096 often give better results\&. Default is 1024\&.
.IP 
.IP "-c" 
Starts ecasound in interactive mode\&. In interactive mode you can
control ecasound with simple commands ("start", "stop", "pause",
etc\&.)\&.
.IP 
.IP "-d:debug level" 
Set the debug level\&. Default is 0\&.
.IP 
.IP "-m:mix-mode" 
Force ecasound to use mix mode \'mix_mode\'\&. \'auto\' = automatic (default),
\'simple\' =  only one input/chain/output, \'normal\' = normal single-threaded
mode and \'multi\' = multithreaded mixing\&. In most cases, ecasound is 
able to find out the correct mode automatically\&.
.IP 
.IP "-r" 
Raise process priority\&. Improves realtime performance\&. 
.IP 
.PP 
\fBCHAIN SETUP\fP
.IP "-a:chainname1, chainname2, \&.\&.\&." 
Sets active signal chains\&. All effects, inputs and outputs are assigned to
these chains\&. If there are no -a options given, default chain is used\&.
Chain name \'all\' is reserved and means that all chains are active\&. By giving 
multiple -a options, you can control to which chains effects, inputs and outputs
are assigned to\&. Look at the 
\fBEXAMPLES\fP
section for more detailed info about the usage of this option\&.
.IP 
.PP 
\fBINPUT/OUTPUT SETUP\fP
.IP "-i input-file-or-device" 
Specifies a new input source\&. It is assigned to the active chains\&. Assigned 
multiple inputs to the same chain is currently not possible\&. The given input 
can be a normal file or an audio device\&. File format is determined 
using the file name extension\&. Currently supported formats are RIFF WAVE files 
(\&.wav), audio-cd tracks (\&.cdr), ecasound ewf-files (\&.ewf), MPEG files (\&.mp3), 
ecasynth configuration files (\&.ess) and OSS audio devices (/dev/dsp*)\&.
If no inputs are specified, the first non-option on the command line
(if any) is considered to be a input\&. Notice! When using ALSA drivers,
the format is \fB-i[:]alsa,card_number,device_number\fP\&.
.IP 
.IP " -o output-file-or-device" 
Acts in the same way as the -i option\&. If no no outputs are specified,
the default output device is used (see &tilde;/\&.ecasoundrc)\&. As with
inputs, then using ALSA drivers, the format is \fB-o[:]alsa,card_number,device_number\fP\&.
.IP 
.IP " -f:bits,channel,sample-rate" 
Sets active sampling parameters\&. These are used for all following input and
output files or until another -f is spesified\&. If no -f option is
present, ecasound tries to get the parameters from the audio object
(for instance RIFF WAVE header)\&. If no valid sample parameters are
found, defaults are used (16 bits, 2 channels, 44100 samples per
second)\&.
.IP 
.PP 
\fBEFFECT SETUP\fP
.PP 
.IP "-ps:preset_name" 
Insert single-chain preset \'preset_name\' to active chains\&.
See ecasoundrc(5) for info about the preset file\&. 
.PP 
\fISIGNAL ANALYSIS\fP
.PP 
.IP 
.IP "-ev" 
Normalize sample data by finding out how much the signal can
be amplified without clipping\&. The resulting percent value
can be used as a parameter to -ea and -eas effects\&.
.IP 
.IP "-ezf" 
Find the optimal value for DC-adjusting\&. You can use the result
as a parameter to -ezx effect\&.
.IP 
.PP 
\fIGENERAL SIGNAL PROCESSING ALGORITHMS\fP
.IP "-ea:amplify-%,max-clipped-samples" 
Amplifies signal by amplify-% percent\&. If number of consecutive
clipped samples (resulting sample has the largest amplitude
possible) reaches \'max-clipped-samples\', a warning will be issued\&.
.IP 
.IP "-eas:amplify-%" 
Otherwise like -ea, but doesn\'t warn about clipped samples\&.
.IP 
.IP "-ec:c_rate,threshold" 
Compressor (a simple one)\&. \'c_rate\' of -1\&.0 resulsts in maximum
compression\&. 0\&.0 means no compression while positive values 
cause expansion\&. \'threshold\' varies between 0\&.0 (silence) and
1\&.0 (max amplitude)\&.
.IP 
.IP "-epp:right-%" 
Normal pan effect\&. Balance value of 0 means to pan signal fully
left and 100 fully right\&. If the panned signal is
a stereo signal, left and right channels aren\'t mixed together\&.
Use the -f option to force conversion to mono before panning\&.
.IP 
.IP "-ezx:left-dc-fix-value,right-dc-fix-value" 
Adjusts the signal DC by \'dc-fix-value\'\&. Use -ezf to find the
optimal value\&.
.IP 
.PP 
\fITIME-BASED EFFECTS\fP
.IP "-etr:delay-time,surround-mode,feedback-%" 
Reverb effect\&. \'delay time\' is the delay time in milliseconds\&.
If \'surround-mode\' is \'1\', reverbed signal moves around the
stereo image\&. \'feedback-%\' determines how much effected (wet)
signal is fed back to the reverb\&.
.IP 
.PP 
\fIFILTER EFFECTS\fP
.IP "-ef1:center_freq, width" 
Resonant bandpass filter\&. \'center_freq\' is the center frequency\&. Width
is specified in Hz\&. 
.IP 
.IP "-ef3:cutoff_freq, reso, gain" 
Resonant lowpass filter\&. \'cutoffr_freq\' is the filter cutoff
frequency\&. \'reso\' means resonance\&. Usually the best values for
resonance are between 1\&.0 and 2\&.0, but you can use even bigger values\&.
\'gain\' is the overall gain-factor\&. It\'s a simple multiplier (1\&.0 
is the normal level)\&. With high resonance values it often is useful 
to reduce the gain value\&.
.IP 
.IP "-efb:center_freq,width" 
Bandpass filter\&. \'center_freq\' is the center frequency\&. Width
is specified in Hz\&. 
.IP 
.IP "-efh:cutoff_freq" 
Highpass filter\&. Only frequencies above \'cutoff_freq\' are passed
through\&.
.IP 
.IP "-efi:delay_in_samples,radius" 
Inverse comb filter\&. Allows the spikes of the comb to pass through\&.
The comb consists of \'delay_in_samples/2\' spikes\&. The maximum
value for \'radius\' is 1\&.0\&. The closer it is to the maximum value,
the deeper the dips of the comb\&.
.IP 
.IP "-efl:cutoff_freq" 
Lowpass filter\&. Only frequencies below \'cutoff_freq\' are passed
through\&.
.IP 
.IP "-efr:center_freq,width" 
Bandreject filter\&. \'center_freq\' is the center frequency\&. Width
is specified in Hz\&. 
.IP 
.IP "-efs:center_freq,width" 
Resonator\&. \'center_freq\' is the center frequency\&. Width is specified
in Hz\&. Basicly just another resonating bandpass filter\&.
.IP 
.PP 
\fBGATE SETUP\fP
.PP 
\fBCONTROL ENVELOPE SETUP\fP
.PP 
\fBINTERACTIVE MODE\fP
.PP 
The interactive mode of ecasound is launched with the -c option\&. In
this mode, ecasound reacts to the following commands:
.IP "\'quit\', \'q\'" 
Quits ecasound\&.
.IP 
.IP "\'exec\'" 
Ecasound starts the processing engine\&. Normally you don\'t need to use
this\&.
.IP 
.IP "\'end\'" 
Ecasound exits the processing engine, but doesn\'t exit the interactive
mode\&. Normally you don\'t need to use this\&.
.IP 
.IP "\'start\', \'t\'" 
Processing is started (play)\&.
.IP 
.IP "\'stop\', \'s\'" 
Stops processing\&. 
.IP 
.IP "\'rewind time-in-seconds\', \'rw time-in-seconds\'" 
Rewind the current position by \'time-in-seconds\' seconds\&.
.IP 
.IP "\'forward time-in-seconds\', \'fw time-in-seconds\'" 
The current position is forwarded by \'time-in-seconds\' seconds\&.
.IP 
.IP "\'setpos time-in-seconds\'" 
Sets the current position to \'time-in-seconds\' seconds from the
beginning\&.
.IP 
.IP "\'status\',\'st\',\'u\'" 
General status info\&.
.IP 
.IP "\'cstatus\',\'cs\',\'a\'" 
Status info about the effect chains\&.
.IP 
.IP "\'estatus\', \'es\',\'x\'" 
Status info about effects and controller envelopes\&.
.IP 
.IP "\'fstatus\', \'fs\',\'l\'" 
Status info about open files and devices\&.
.IP 
.IP "\'sfx\'" 
Enable/disable the sound effects section\&.
.IP 
.IP "\'chain chainname\', \'c chainname\'" 
Enable/disable the the chain \'chainname\'\&.
.IP 
.IP "\'loop\'" 
Start/stop looping\&.
.IP 
.IP "\'loop_start seconds_from_start\'" 
Set the start point for looping\&.
.IP 
.IP "loop_end seconds_from_start\'" 
Set the end point for looping\&.
.IP 
.IP "\'help\', \'h\'" 
Help!
.IP 
.PP 
.SH "FILES" 
.PP 
\fI~/\&.ecasoundrc\fP
The default ecasound resource file\&. See \fIecasoundrc(5)\fP 
man page\&.
.PP 
.SH "SEE ALSO" 
.PP 
qtecasound (1), ecasoundrc(5), "HTML docs in the Documentation subdirectory"
.PP 
.SH "BUGS" 
.PP 
Lots of\&.\&.\&. ;) See the file BUGS\&. If ecasound behaves weirdly, try to
increase the debug level to see what\'s going on\&.
.PP 
.SH "AUTHOR" 
.PP 
Kai Vehmanen, <kaiv@wakkanet\&.fi>
