#include <cmath>

#include <kvutils.h>

#include "oscillator.h"
#include "osc-sine.h"
#include "debug.h"

double SINE_OSCILLATOR::value(void) {
  curval = (sin(phase) + 1.0) / 2.0;
  //  ecadebug->msg(5, "Sine-osc, new value: " + kvu_numtostr(curval) + ".");
  phase += phasemod * phase_step();
  //  ecadebug->msg(5, "Sine-osc, new  phase: " + kvu_numtostr(phase) + ".");
  return(curval);
}

SINE_OSCILLATOR::SINE_OSCILLATOR (double step, double freq, double initial_phase) :
  OSCILLATOR(step, freq, initial_phase) 
{
    L = 1.0 / frequency();   // length of one wave in seconds
    //    L = L * 1000.0;   // length of one wave in milliseconds

    phase = phase_offset();
    phasemod = 2.0 * M_PI / L; 
        
    MESSAGE_ITEM otemp;
    otemp << "(osc-sine) Sine oscillator created; frequency ";
    otemp.setprecision(1);
    otemp << frequency();
    otemp << " and initial phase of "; 
    otemp << phase_offset() << ".";
    ecadebug->msg(otemp.to_string());
}
