// ------------------------------------------------------------------------
// kvutils.cpp: Misc helper routines.
// Copyright (C) 1999 Kai Vehmanen (kaiv@wakkanet.fi)
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
// ------------------------------------------------------------------------

#include <string>
#include <vector>

#include "kvutils.h"

vector<string> string_to_words(const string& s) {
  vector<string> vec;
  string stmp = "";

  for(string::const_iterator p = s.begin(); p != s.end(); p++) {
    if (isspace(*p) == false)
      stmp += *p;
    else {
      if (stmp == "") continue;
      vec.push_back(stmp);
      //      cout << "EDebug - added word: " << stmp << ".\n";
      stmp = "";
    }
  }
  if (stmp.size() > 0)
    vec.push_back(stmp);

  return(vec);
}

bool string_icmp(const string& first, const string& second) {
  //
  // Returns true if string 'first' and 'second' match. 
  // Case insensitive, ignores preceding and trailing spaces.
  //

  string a = first;
  string b = second;

  a = remove_trailing_spaces(a);
  a = remove_preceding_spaces(a);
  a = convert_to_uppercase(a);

  b = remove_trailing_spaces(b);
  b = remove_preceding_spaces(b);
  b = convert_to_uppercase(b);

  //  cout << "Converted f " << first << " to " << a << ".\n";
  //  cout << "Converted s " << second << " to " << b << ".\n";

  return(a == b);
}

string remove_trailing_spaces(const string& a) { 
  string r = "";
  string::const_reverse_iterator p;
  for(p = a.rbegin(); p != a.rend(); p++) {
    if (*p != ' ') break;
  }
  for(; p != a.rend(); p++) {
    r = *p + r;
  }
  return(r);
}

string remove_preceding_spaces(const string& a) { 
  string r = "";
  string::const_iterator p;
  for(p = a.begin(); p != a.end(); p++) {
    if (*p != ' ') break;
  }
  for(; p != a.end(); p++) {
    r = *p + r;
  }
  return(r);
}

string convert_to_uppercase(const string& a) { 
  string r = a;
  for(string::iterator p = r.begin(); p != r.end(); p++)
    *p = toupper(*p);
  return(r);
}

