// ------------------------------------------------------------------------
// eca-qtrtposition.cpp: A horizontal slider with two-way data
// exchange.
// Copyright (C) 1999 Kai Vehmanen (kaiv@wakkanet.fi)
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
// ------------------------------------------------------------------------

#include <cmath>
#include <iostream>

#include <qwidget.h>
#include <qslider.h>
#include <qwindowsstyle.h>

#include "eca-qtrtposition.h"

QERuntimePosition::QERuntimePosition (double length, QWidget *parent=0, const char
				      *name=0) :
QSlider(QSlider::Horizontal, parent, name)
{
  mouse_pressed = false;
  length_in_seconds(length);
  //  setBackgroundColor("white");
  setTickmarks(QSlider::Both);
  setRange(0, 1000);
  setTickInterval(500);
  setStyle(new QWindowsStyle());
  connect(this, SIGNAL(sliderReleased()), this, SLOT(position_changed()));
  connect(this, SIGNAL(sliderPressed()), this, SLOT(mouse_active()));
}

void QERuntimePosition::length_in_seconds(double seconds) {
  totallen = seconds;

  //  setRange(1,(int)ceil(totallen));
}

void QERuntimePosition::position_in_seconds(double seconds) {
  if (mouse_pressed) return;
  if (seconds < totallen) 
    position = seconds;

  last_normally_changed = (int)floor(position * 1000.0 / totallen);
  setValue(last_normally_changed);

  //  repaint();
}

void QERuntimePosition::position_changed(void) {
  if (value() == last_normally_changed) return;
  //  cerr << "User touching my goddam slider! :)\n";
  emit position_changed(value() / 1000.0 * totallen);
  mouse_pressed = false;
}

void QERuntimePosition::mouse_active(void) { mouse_pressed = true; }
