#ifndef _CHAINOP_H
#define _CHAINOP_H

#include <vector>
#include <string>

#include "samplebuffer.h"

class CHAIN_OPERATOR {
  //
  // Interface for all chain operator classes. 
  //
 
  bool dynparam_support;

public:

  // Functions returning info about effect and its parameters.
  // ---
  virtual void set_parameter(int param, double value) { }
  virtual double get_parameter(int param) { }

  bool support_for_dynamic_parameters(void) { return(dynparam_support); }
  void support_for_dynamic_parameters(bool t) { dynparam_support = t; }

  virtual string label(void) = 0;
  virtual string params(void) { return(""); }
  virtual int number_of_params(void) { return(0); }
  virtual void process(SAMPLE_BUFFER* sbuf) {
    sbuf->first();
    //    cerr << "First to effect, left/right: " << sbuf->current_sample()->get_left() << ", "<< sbuf->current_sample()->get_right() << ".\n";
    while(sbuf->is_readable()) {
      process(sbuf->current_sample());
      sbuf->next();
    }
    //    sbuf->first();
    //    cerr << "First after effect, left/right: " << sbuf->current_sample()->get_left() << ", "<< sbuf->current_sample()->get_right() << ".\n";
  }
  virtual void process(SAMPLE_BUFFER::sample_type *) { };
  virtual void status(string* output) { }
  
  virtual ~CHAIN_OPERATOR (void) { }
};

#endif
