#ifndef _AUDIOIO_OSS_DMA_H
#define _AUDIOIO_OSS_DMA_H

#include <string>

#include <unistd.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/mman.h>
#include <sys/ioctl.h>
#include <sys/time.h>
#include <soundcard.h>

#include "samplebuffer.h"

class OSSDMA : public AUDIO_IO_DEVICE {
//
// Class for handling OSS -devices in DMA-mode (Open Sound System/Linux).
//
// ---

    int audio_fd;

    audio_buf_info audiobuf;          // soundcard.h
    count_info audioinfo;             // soundcard.h
    fd_set fds;
    struct timeval tv;
    caddr_t buf;
    fd_set writeset;
    struct timeval tim;
    struct count_info count;

    unsigned char *op;
    int fragment_size;
    int total_oss_buffersize;
    int extrabits;

    bool is_open;
    bool is_triggered;
    SIMODE simode;
    int buffersize;

    void open_device(void);
    void close_device(void);

 public:
    
    void enable(void);
    void disable(void);

    void   get_sample(SAMPLE_BUFFER* t);
    void   put_sample(SAMPLE_BUFFER* t);

    void first(void) { }
    void last(void) { }

    bool is_realtime(void) const  { return(true); }
    
    long   length_in_samples(void) const { return(0); }
    long   position_in_samples(void) const { return(0); }
    void   position_in_samples(long pos) { }

    OSSDMA (const string& name, const SIMODE mode, const AIO_PARAMS& form, int buffersize);
    OSSDMA::~OSSDMA(void);
    //    OSSDMA* new_expr(void) { return new OSSDMA(); }
    OSSDMA* clone(void) { return new OSSDMA(*this); }
};

#endif
