#ifndef _AUDIOIO_EWF_H
#define _AUDIOIO_EWF_H

#include <string>
#include "audioio.h"
#include "audioio-wave.h"
#include "samplebuffer.h"

class EWFFILE : public AUDIO_IO_DEVICE {
//
// Ecasound Wave File (.EWF) class. Combination of ascii config
// file and RIFF WAVE sample data file.
//

    WAVEFILE* wobject;

    long curpos_in_samples;
    bool wave_object_active;
    long sample_offset;    

    string wavename, ewfname;
    
    void read_ewf_parametres(void);
    void write_ewf_parametres(void);

    // attributes from .ewf data file...:

    EWFFILE& operator=(const EWFFILE& x) { }

 public:
    
    inline const AIO_PARAMS& format(void) { return(wobject->format()); }
    bool finished(void) const { return(wobject->finished()); }
        
    void   get_sample(SAMPLE_BUFFER* t);
    void   put_sample(SAMPLE_BUFFER* t);
    void   first(void);
    void   last(void);

    inline bool is_realtime(void) const { return(false); }
    
    long   length_in_samples(void) const;
    long   position_in_samples(void) const;
    void   position_in_samples(long pos);
    
    //    EWFFILE* new_expr(void) { return new EWFFILE(); }
    EWFFILE* clone(void) { return new EWFFILE(*this); }    
    
    EWFFILE (const string& name, const SIMODE mode, const AIO_PARAMS& form);
    ~EWFFILE(void);
};

#endif
