#ifndef _AUDIOIO_CDR_H
#define _AUDIOIO_CDR_H

#include <string>
#include "samplebuffer.h"

class CDRFILE : public AUDIO_IO_DEVICE {
  //
  // Represent a CDR -file. 
  //
  // CDR -format is the format used in audio-CDs:
  //     - 16bit samples, 44100kHz, stereo
  //     - one sample is coded: (MSB-left, LSB-left, MSB-right, LSB-right)
  //     - samples are coded in sectors (2352 bytes)
  //

  static const int sectorsize = 2352;

  long int curpos_value;
  long int length_in_bytes_value;
  int samples;       // number of samples written
  FILE* fobject;
  void pad_to_sectorsize(void);
  long int get_length_in_bytes(void);
  long int length_in_bytes(void) const;
  long int curpos(void)  const { return(curpos_value); }
  long int get_curpos(void);

  CDRFILE(const CDRFILE& x) { }
  CDRFILE& operator=(const CDRFILE& x) { }

  unsigned short swapw(unsigned short us) { return ((us >> 8) | (us << 8)) & 0xffff;  }

  void swap_bytes(SAMPLE* t) {
    if (format().bits == 16) {
      t->sample[SAMPLE_BUFFER::ch_left] = swapw(t->sample[SAMPLE_BUFFER::ch_left]);
      t->sample[SAMPLE_BUFFER::ch_right] = swapw(t->sample[SAMPLE_BUFFER::ch_right]);
    }
  }
    
 public:

  void   get_sample(SAMPLE_BUFFER* t);
  void   put_sample(SAMPLE_BUFFER* t);
    
  void   first(void);
  void   last(void);

  inline bool is_realtime(void) const { return(false); }

  long length_in_samples(void)  const { return(length_in_bytes_value / format().align); }
  long position_in_samples(void)  const { return(curpos_value / format().align); }
  void   position_in_samples(long pos);

  CDRFILE (const string& name, const SIMODE mode, const AIO_PARAMS& format);
  CDRFILE::~CDRFILE(void);
    
  CDRFILE* clone(void) { return new CDRFILE(*this); }    
};

#endif
