#include <string>
#include <utility>	
#include <deque>
#include <pthread.h>

#include "value_queue.h"

void VALUE_QUEUE::push_back(pair<string,double>& cmd) {
    pthread_mutex_lock(&clock);
    cmds.push_back(cmd);
    pthread_mutex_unlock(&clock);
}

void VALUE_QUEUE::pop_front(void) {
    pthread_mutex_lock(&clock);
    cmds.pop_front();
    pthread_mutex_unlock(&clock);
}    

pair<string,double> VALUE_QUEUE::front(void) {
   if (pthread_mutex_trylock(&clock) != 0)
        return(emptypair);
    pair<string,double> s = cmds.front();
    pthread_mutex_unlock(&clock);   
    return(s);
}

bool VALUE_QUEUE::cmds_available(void) {
    if (pthread_mutex_trylock(&clock) != 0)
        return(false);
    bool temp = false;
    if (cmds.size() > 0) temp = true;
    pthread_mutex_unlock(&clock);
    return(temp);
}    

