#ifndef _VALUE_QUEUE_H
#define _VALUE_QUEUE_H

#include <pthread.h>
#include <string>
#include <deque>
#include <utility>

class VALUE_QUEUE {
    
private:
    pthread_mutex_t clock;     // mutex ensuring exclusive access to buffer

    deque<pair<string,double> > cmds;
    pair<string,double> emptypair;

public:
    void push_back(pair<string,double>& cmd);
    void pop_front(void);
    pair<string,double> front(void);
    bool cmds_available(void);

    VALUE_QUEUE(void) { }
};

#endif

