#include <string>
#include <vector>

#include "kvutils.h"

vector<string> string_to_words(const string& s) {
  vector<string> vec;
  string stmp = "";

  for(string::const_iterator p = s.begin(); p != s.end(); p++) {
    if (isspace(*p) == false)
      stmp += *p;
    else {
      if (stmp == "") continue;
      vec.push_back(stmp);
      //      cout << "EDebug - added word: " << stmp << ".\n";
      stmp = "";
    }
  }
  if (stmp.size() > 0)
    vec.push_back(stmp);

  return(vec);
}

bool string_icmp(const string& first, const string& second) {
  //
  // Returns true if string 'first' and 'second' match. 
  // Case insensitive, ignores preceding and trailing spaces.
  //

  string a = first;
  string b = second;

  a = remove_trailing_spaces(a);
  a = remove_preceding_spaces(a);
  a = convert_to_uppercase(a);

  b = remove_trailing_spaces(b);
  b = remove_preceding_spaces(b);
  b = convert_to_uppercase(b);

  //  cout << "Converted f " << first << " to " << a << ".\n";
  //  cout << "Converted s " << second << " to " << b << ".\n";

  return(a == b);
}

string remove_trailing_spaces(const string& a) { 
  string r = "";
  string::const_reverse_iterator p;
  for(p = a.rbegin(); p != a.rend(); p++) {
    if (*p != ' ') break;
  }
  for(; p != a.rend(); p++) {
    r = *p + r;
  }
  return(r);
}

string remove_preceding_spaces(const string& a) { 
  string r = "";
  string::const_iterator p;
  for(p = a.begin(); p != a.end(); p++) {
    if (*p != ' ') break;
  }
  for(; p != a.end(); p++) {
    r = *p + r;
  }
  return(r);
}

string convert_to_uppercase(const string& a) { 
  string r = a;
  for(string::iterator p = r.begin(); p != r.end(); p++)
    *p = toupper(*p);
  return(r);
}

