#include <string>
#include <pthread.h>

#include "command_queue.h"

pthread_mutex_t _cq_lock = PTHREAD_MUTEX_INITIALIZER;

void COMMAND_QUEUE::push_back(const string& cmd) {
    pthread_mutex_lock(&_cq_lock);
    cmds.push_back(cmd);
    pthread_mutex_unlock(&_cq_lock);
}

void COMMAND_QUEUE::pop_front(void) {
    pthread_mutex_lock(&_cq_lock);
    cmds.pop_front();
    pthread_mutex_unlock(&_cq_lock);
}    

string COMMAND_QUEUE::front(void) {
  //    if (pthread_mutex_trylock(&_cq_lock) == EBUSY)
    if (pthread_mutex_trylock(&_cq_lock) != 0)
        return("");
    string s = string(cmds.front());
    pthread_mutex_unlock(&_cq_lock);   
    return(s);
}

bool COMMAND_QUEUE::cmds_available(void) {
  //    if (pthread_mutex_trylock(&_cq_lock) == EBUSY)
    if (pthread_mutex_trylock(&_cq_lock) != 0)
        return(false);
    bool temp = false;
    if (cmds.size() > 0) temp = true;
    pthread_mutex_unlock(&_cq_lock);
    return(temp);
}    

