
#include "ladspa.h"

extern
void
set_qcs_framerate(unsigned long framerate);

extern
void
set_qcs_controlrate(unsigned long samplecount);
#include "vdelay.h"


LADSPA_Handle
STVB_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	STVB * i = new STVB;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum STVB_port_enum {
	STVB_out_enum, STVB_in_enum, STVB_time_enum, STVB_hdif_enum, STVB_istor_enum, STVB_cbuf_cur_enum, STVB_abuf_cur_enum, 
};

void
STVB_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	STVB * ins = (STVB *)Instance;
	switch(Port) {

		case STVB_out_enum:
			ins->out = DataLocation;
			break;

		case STVB_in_enum:
			ins->in = DataLocation;
			break;

		case STVB_time_enum:
			ins->time = DataLocation;
			break;

		case STVB_hdif_enum:
			ins->hdif = DataLocation;
			break;

		case STVB_istor_enum:
			ins->istor = DataLocation;
			break;

		case STVB_cbuf_cur_enum:
			ins->cbuf_cur = DataLocation;
			break;

		case STVB_abuf_cur_enum:
			ins->abuf_cur = DataLocation;
			break;

		default:
			break;
	}
}

LADSPA_Handle
NREV_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	NREV * i = new NREV;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum NREV_port_enum {
	NREV_out_enum, NREV_in_enum, NREV_time_enum, NREV_hdif_enum, NREV_istor_enum, NREV_cbuf_cur_enum, NREV_abuf_cur_enum, 
};

void
NREV_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	NREV * ins = (NREV *)Instance;
	switch(Port) {

		case NREV_out_enum:
			ins->out = DataLocation;
			break;

		case NREV_in_enum:
			ins->in = DataLocation;
			break;

		case NREV_time_enum:
			ins->time = DataLocation;
			break;

		case NREV_hdif_enum:
			ins->hdif = DataLocation;
			break;

		case NREV_istor_enum:
			ins->istor = DataLocation;
			break;

		case NREV_cbuf_cur_enum:
			ins->cbuf_cur = DataLocation;
			break;

		case NREV_abuf_cur_enum:
			ins->abuf_cur = DataLocation;
			break;

		default:
			break;
	}
}

LADSPA_Handle
MDEL_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	MDEL * i = new MDEL;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum MDEL_port_enum {
	MDEL_sr_enum, MDEL_ain_enum, MDEL_ndel_enum, 
};

void
MDEL_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	MDEL * ins = (MDEL *)Instance;
	switch(Port) {

		case MDEL_sr_enum:
			ins->sr = DataLocation;
			break;

		case MDEL_ain_enum:
			ins->ain = DataLocation;
			break;

		case MDEL_ndel_enum:
			ins->ndel = DataLocation;
			break;

		default:
			break;
	}
}

LADSPA_Handle
VDEL_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	VDEL * i = new VDEL;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum VDEL_port_enum {
	VDEL_sr_enum, VDEL_ain_enum, VDEL_adel_enum, VDEL_imaxd_enum, VDEL_istod_enum, 
};

void
VDEL_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	VDEL * ins = (VDEL *)Instance;
	switch(Port) {

		case VDEL_sr_enum:
			ins->sr = DataLocation;
			break;

		case VDEL_ain_enum:
			ins->ain = DataLocation;
			break;

		case VDEL_adel_enum:
			ins->adel = DataLocation;
			break;

		case VDEL_imaxd_enum:
			ins->imaxd = DataLocation;
			break;

		case VDEL_istod_enum:
			ins->istod = DataLocation;
			break;

		default:
			break;
	}
}

LADSPA_Handle
BASIC_OP_ARG_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	BASIC_OP_ARG * i = new BASIC_OP_ARG;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum BASIC_OP_ARG_port_enum {
	
};

void
BASIC_OP_ARG_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	BASIC_OP_ARG * ins = (BASIC_OP_ARG *)Instance;
	switch(Port) {

		default:
			break;
	}
}

void
vdelay_activate(LADSPA_Handle Instance)
{
	VDEL * ins = (VDEL *)Instance;
	vdelset(ins);
}

void
vdelay_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	VDEL * ins = (VDEL *)Instance;
	set_qcs_controlrate(SampleCount);
	vdelay(ins);
}

void
vdelay_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_vdelay_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "vdelay";
	d->Name = "vdelay";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 5;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="sr";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_AUDIO | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="ain";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[2]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[2]="adel";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[2].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[3]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[3]="imaxd";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[3].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[4]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[4]="istod";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[4].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = VDEL_instantiate;
	d->connect_port = VDEL_connect_port;
	d->activate = vdelay_activate;
	d->run = vdelay_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = vdelay_cleanup;
	return d;
}

void
nreverb_activate(LADSPA_Handle Instance)
{
	NREV * ins = (NREV *)Instance;
	nreverb_set(ins);
}

void
nreverb_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	NREV * ins = (NREV *)Instance;
	set_qcs_controlrate(SampleCount);
	nreverb(ins);
}

void
nreverb_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_nreverb_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "nreverb";
	d->Name = "nreverb";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 5;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="out";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_AUDIO | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="in";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[2]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[2]="time";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[2].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[3]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[3]="hdif";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[3].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[4]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[4]="istor";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[4].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = NREV_instantiate;
	d->connect_port = NREV_connect_port;
	d->activate = nreverb_activate;
	d->run = nreverb_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = nreverb_cleanup;
	return d;
}

void
multitap_activate(LADSPA_Handle Instance)
{
	MDEL * ins = (MDEL *)Instance;
	multitap_set(ins);
}

void
multitap_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	MDEL * ins = (MDEL *)Instance;
	set_qcs_controlrate(SampleCount);
	multitap_play(ins);
}

void
multitap_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_multitap_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "multitap";
	d->Name = "multitap";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 3;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="sr";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_AUDIO | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="ain";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[2]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[2]="ndel";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[2].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = MDEL_instantiate;
	d->connect_port = MDEL_connect_port;
	d->activate = multitap_activate;
	d->run = multitap_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = multitap_cleanup;
	return d;
}

void
reverb2_activate(LADSPA_Handle Instance)
{
	NREV * ins = (NREV *)Instance;
	nreverb_set(ins);
}

void
reverb2_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	NREV * ins = (NREV *)Instance;
	set_qcs_controlrate(SampleCount);
	nreverb(ins);
}

void
reverb2_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_reverb2_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "reverb2";
	d->Name = "reverb2";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 5;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="out";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_AUDIO | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="in";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[2]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[2]="time";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[2].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[3]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[3]="hdif";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[3].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[4]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[4]="istor";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[4].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = NREV_instantiate;
	d->connect_port = NREV_connect_port;
	d->activate = reverb2_activate;
	d->run = reverb2_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = reverb2_cleanup;
	return d;
}

enum descriptor_enum {
	multitap_desc_enum, nreverb_desc_enum, vdelay_desc_enum, reverb2_desc_enum, 
};

const LADSPA_Descriptor *
ladspa_descriptor(unsigned long Index)
{
	static bool inited=false;
	static LADSPA_Descriptor *multitap_desc_pointer;
	static LADSPA_Descriptor *nreverb_desc_pointer;
	static LADSPA_Descriptor *vdelay_desc_pointer;
	static LADSPA_Descriptor *reverb2_desc_pointer;

	if (!inited) {
		multitap_desc_pointer = new_multitap_desc();
		nreverb_desc_pointer = new_nreverb_desc();
		vdelay_desc_pointer = new_vdelay_desc();
		reverb2_desc_pointer = new_reverb2_desc();

		inited=true;
	}
	
	switch(Index) {
		case multitap_desc_enum : return multitap_desc_pointer;
		case nreverb_desc_enum : return nreverb_desc_pointer;
		case vdelay_desc_enum : return vdelay_desc_pointer;
		case reverb2_desc_enum : return reverb2_desc_pointer;

		default:
			return 0;
	}
}
