
#include "ladspa.h"

extern
void
set_qcs_framerate(unsigned long framerate);

extern
void
set_qcs_controlrate(unsigned long samplecount);
#include "ugens6.h"


LADSPA_Handle
PAN_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	PAN * i = new PAN;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum PAN_port_enum {
	PAN_r1_enum, PAN_r2_enum, PAN_r3_enum, PAN_r4_enum, PAN_asig_enum, PAN_kx_enum, PAN_ky_enum, PAN_ifn_enum, PAN_imode_enum, PAN_ioffset_enum, 
};

void
PAN_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	PAN * ins = (PAN *)Instance;
	switch(Port) {

		case PAN_r1_enum:
			ins->r1 = DataLocation;
			break;

		case PAN_r2_enum:
			ins->r2 = DataLocation;
			break;

		case PAN_r3_enum:
			ins->r3 = DataLocation;
			break;

		case PAN_r4_enum:
			ins->r4 = DataLocation;
			break;

		case PAN_asig_enum:
			ins->asig = DataLocation;
			break;

		case PAN_kx_enum:
			ins->kx = DataLocation;
			break;

		case PAN_ky_enum:
			ins->ky = DataLocation;
			break;

		case PAN_ifn_enum:
			ins->ifn = DataLocation;
			break;

		case PAN_imode_enum:
			ins->imode = DataLocation;
			break;

		case PAN_ioffset_enum:
			ins->ioffset = DataLocation;
			break;

		default:
			break;
	}
}

LADSPA_Handle
COMB_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	COMB * i = new COMB;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum COMB_port_enum {
	COMB_ar_enum, COMB_asig_enum, COMB_krvt_enum, COMB_ilpt_enum, COMB_istor_enum, COMB_pntr_enum, 
};

void
COMB_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	COMB * ins = (COMB *)Instance;
	switch(Port) {

		case COMB_ar_enum:
			ins->ar = DataLocation;
			break;

		case COMB_asig_enum:
			ins->asig = DataLocation;
			break;

		case COMB_krvt_enum:
			ins->krvt = DataLocation;
			break;

		case COMB_ilpt_enum:
			ins->ilpt = DataLocation;
			break;

		case COMB_istor_enum:
			ins->istor = DataLocation;
			break;

		case COMB_pntr_enum:
			ins->pntr = DataLocation;
			break;

		default:
			break;
	}
}

LADSPA_Handle
REVERB_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	REVERB * i = new REVERB;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum REVERB_port_enum {
	REVERB_ar_enum, REVERB_asig_enum, REVERB_krvt_enum, REVERB_istor_enum, 
};

void
REVERB_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	REVERB * ins = (REVERB *)Instance;
	switch(Port) {

		case REVERB_ar_enum:
			ins->ar = DataLocation;
			break;

		case REVERB_asig_enum:
			ins->asig = DataLocation;
			break;

		case REVERB_krvt_enum:
			ins->krvt = DataLocation;
			break;

		case REVERB_istor_enum:
			ins->istor = DataLocation;
			break;

		default:
			break;
	}
}

LADSPA_Handle
SAMPHOLD_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	SAMPHOLD * i = new SAMPHOLD;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum SAMPHOLD_port_enum {
	SAMPHOLD_xr_enum, SAMPHOLD_xsig_enum, SAMPHOLD_xgate_enum, SAMPHOLD_ival_enum, SAMPHOLD_istor_enum, 
};

void
SAMPHOLD_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	SAMPHOLD * ins = (SAMPHOLD *)Instance;
	switch(Port) {

		case SAMPHOLD_xr_enum:
			ins->xr = DataLocation;
			break;

		case SAMPHOLD_xsig_enum:
			ins->xsig = DataLocation;
			break;

		case SAMPHOLD_xgate_enum:
			ins->xgate = DataLocation;
			break;

		case SAMPHOLD_ival_enum:
			ins->ival = DataLocation;
			break;

		case SAMPHOLD_istor_enum:
			ins->istor = DataLocation;
			break;

		default:
			break;
	}
}

LADSPA_Handle
DELAY_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	DELAY * i = new DELAY;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum DELAY_port_enum {
	DELAY_ar_enum, DELAY_asig_enum, DELAY_idlt_enum, DELAY_istor_enum, DELAY_curp_enum, 
};

void
DELAY_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	DELAY * ins = (DELAY *)Instance;
	switch(Port) {

		case DELAY_ar_enum:
			ins->ar = DataLocation;
			break;

		case DELAY_asig_enum:
			ins->asig = DataLocation;
			break;

		case DELAY_idlt_enum:
			ins->idlt = DataLocation;
			break;

		case DELAY_istor_enum:
			ins->istor = DataLocation;
			break;

		case DELAY_curp_enum:
			ins->curp = DataLocation;
			break;

		default:
			break;
	}
}

LADSPA_Handle
DELAYW_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	DELAYW * i = new DELAYW;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum DELAYW_port_enum {
	DELAYW_asig_enum, 
};

void
DELAYW_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	DELAYW * ins = (DELAYW *)Instance;
	switch(Port) {

		case DELAYW_asig_enum:
			ins->asig = DataLocation;
			break;

		default:
			break;
	}
}

LADSPA_Handle
BASIC_OP_ARG_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	BASIC_OP_ARG * i = new BASIC_OP_ARG;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum BASIC_OP_ARG_port_enum {
	
};

void
BASIC_OP_ARG_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	BASIC_OP_ARG * ins = (BASIC_OP_ARG *)Instance;
	switch(Port) {

		default:
			break;
	}
}

LADSPA_Handle
DELAYR_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	DELAYR * i = new DELAYR;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum DELAYR_port_enum {
	DELAYR_ar_enum, DELAYR_idlt_enum, DELAYR_istor_enum, DELAYR_curp_enum, 
};

void
DELAYR_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	DELAYR * ins = (DELAYR *)Instance;
	switch(Port) {

		case DELAYR_ar_enum:
			ins->ar = DataLocation;
			break;

		case DELAYR_idlt_enum:
			ins->idlt = DataLocation;
			break;

		case DELAYR_istor_enum:
			ins->istor = DataLocation;
			break;

		case DELAYR_curp_enum:
			ins->curp = DataLocation;
			break;

		default:
			break;
	}
}

LADSPA_Handle
INDIFF_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	INDIFF * i = new INDIFF;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum INDIFF_port_enum {
	INDIFF_rslt_enum, INDIFF_xsig_enum, INDIFF_istor_enum, 
};

void
INDIFF_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	INDIFF * ins = (INDIFF *)Instance;
	switch(Port) {

		case INDIFF_rslt_enum:
			ins->rslt = DataLocation;
			break;

		case INDIFF_xsig_enum:
			ins->xsig = DataLocation;
			break;

		case INDIFF_istor_enum:
			ins->istor = DataLocation;
			break;

		default:
			break;
	}
}

LADSPA_Handle
DELAY1_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	DELAY1 * i = new DELAY1;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum DELAY1_port_enum {
	DELAY1_ar_enum, DELAY1_asig_enum, DELAY1_istor_enum, 
};

void
DELAY1_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	DELAY1 * ins = (DELAY1 *)Instance;
	switch(Port) {

		case DELAY1_ar_enum:
			ins->ar = DataLocation;
			break;

		case DELAY1_asig_enum:
			ins->asig = DataLocation;
			break;

		case DELAY1_istor_enum:
			ins->istor = DataLocation;
			break;

		default:
			break;
	}
}

LADSPA_Handle
DOWNSAMP_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	DOWNSAMP * i = new DOWNSAMP;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum DOWNSAMP_port_enum {
	DOWNSAMP_kr_enum, DOWNSAMP_asig_enum, DOWNSAMP_ilen_enum, 
};

void
DOWNSAMP_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	DOWNSAMP * ins = (DOWNSAMP *)Instance;
	switch(Port) {

		case DOWNSAMP_kr_enum:
			ins->kr = DataLocation;
			break;

		case DOWNSAMP_asig_enum:
			ins->asig = DataLocation;
			break;

		case DOWNSAMP_ilen_enum:
			ins->ilen = DataLocation;
			break;

		default:
			break;
	}
}

LADSPA_Handle
UPSAMP_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	UPSAMP * i = new UPSAMP;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum UPSAMP_port_enum {
	UPSAMP_ar_enum, UPSAMP_ksig_enum, 
};

void
UPSAMP_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	UPSAMP * ins = (UPSAMP *)Instance;
	switch(Port) {

		case UPSAMP_ar_enum:
			ins->ar = DataLocation;
			break;

		case UPSAMP_ksig_enum:
			ins->ksig = DataLocation;
			break;

		default:
			break;
	}
}

LADSPA_Handle
DELTAP_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	DELTAP * i = new DELTAP;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum DELTAP_port_enum {
	DELTAP_ar_enum, DELTAP_xdlt_enum, 
};

void
DELTAP_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	DELTAP * ins = (DELTAP *)Instance;
	switch(Port) {

		case DELTAP_ar_enum:
			ins->ar = DataLocation;
			break;

		case DELTAP_xdlt_enum:
			ins->xdlt = DataLocation;
			break;

		default:
			break;
	}
}

void
pan_activate(LADSPA_Handle Instance)
{
	PAN * ins = (PAN *)Instance;
	panset(ins);
}

void
pan_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	PAN * ins = (PAN *)Instance;
	set_qcs_controlrate(SampleCount);
	pan(ins);
}

void
pan_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_pan_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "pan";
	d->Name = "pan";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 10;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="r1";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[1]="r2";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[2]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[2]="r3";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[2].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[3]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[3]="r4";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[3].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[4]=LADSPA_PORT_AUDIO | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[4]="asig";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[4].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[5]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[5]="kx";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[5].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[6]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[6]="ky";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[6].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[7]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[7]="ifn";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[7].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[8]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[8]="imode";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[8].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[9]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[9]="ioffset";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[9].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = PAN_instantiate;
	d->connect_port = PAN_connect_port;
	d->activate = pan_activate;
	d->run = pan_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = pan_cleanup;
	return d;
}

void
deltapi_activate(LADSPA_Handle Instance)
{
	DELTAP * ins = (DELTAP *)Instance;
	tapset(ins);
}

void
deltapi_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	DELTAP * ins = (DELTAP *)Instance;
	set_qcs_controlrate(SampleCount);
	deltapi(ins);
}

void
deltapi_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_deltapi_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "deltapi";
	d->Name = "deltapi";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 2;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="ar";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="xdlt";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = DELTAP_instantiate;
	d->connect_port = DELTAP_connect_port;
	d->activate = deltapi_activate;
	d->run = deltapi_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = deltapi_cleanup;
	return d;
}

void
comb_activate(LADSPA_Handle Instance)
{
	COMB * ins = (COMB *)Instance;
	cmbset(ins);
}

void
comb_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	COMB * ins = (COMB *)Instance;
	set_qcs_controlrate(SampleCount);
	comb(ins);
}

void
comb_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_comb_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "comb";
	d->Name = "comb";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 5;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="ar";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_AUDIO | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="asig";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[2]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[2]="krvt";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[2].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[3]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[3]="ilpt";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[3].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[4]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[4]="istor";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[4].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = COMB_instantiate;
	d->connect_port = COMB_connect_port;
	d->activate = comb_activate;
	d->run = comb_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = comb_cleanup;
	return d;
}

void
reverb_activate(LADSPA_Handle Instance)
{
	REVERB * ins = (REVERB *)Instance;
	rvbset(ins);
}

void
reverb_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	REVERB * ins = (REVERB *)Instance;
	set_qcs_controlrate(SampleCount);
	reverb(ins);
}

void
reverb_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_reverb_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "reverb";
	d->Name = "reverb";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 4;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="ar";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_AUDIO | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="asig";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[2]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[2]="krvt";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[2].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[3]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[3]="istor";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[3].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = REVERB_instantiate;
	d->connect_port = REVERB_connect_port;
	d->activate = reverb_activate;
	d->run = reverb_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = reverb_cleanup;
	return d;
}

void
diff_activate(LADSPA_Handle Instance)
{
	INDIFF * ins = (INDIFF *)Instance;
	indfset(ins);
}

void
diff_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	INDIFF * ins = (INDIFF *)Instance;
	set_qcs_controlrate(SampleCount);
	diff(ins);
}

void
diff_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_diff_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "diff";
	d->Name = "diff";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 3;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_CONTROL | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="rslt";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="xsig";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[2]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[2]="istor";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[2].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = INDIFF_instantiate;
	d->connect_port = INDIFF_connect_port;
	d->activate = diff_activate;
	d->run = diff_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = diff_cleanup;
	return d;
}

void
samphold_activate(LADSPA_Handle Instance)
{
	SAMPHOLD * ins = (SAMPHOLD *)Instance;
	samphset(ins);
}

void
samphold_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	SAMPHOLD * ins = (SAMPHOLD *)Instance;
	set_qcs_controlrate(SampleCount);
	samphold(ins);
}

void
samphold_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_samphold_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "samphold";
	d->Name = "samphold";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 5;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_CONTROL | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="xr";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="xsig";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[2]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[2]="xgate";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[2].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[3]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[3]="ival";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[3].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[4]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[4]="istor";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[4].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = SAMPHOLD_instantiate;
	d->connect_port = SAMPHOLD_connect_port;
	d->activate = samphold_activate;
	d->run = samphold_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = samphold_cleanup;
	return d;
}

void
delay_activate(LADSPA_Handle Instance)
{
	DELAY * ins = (DELAY *)Instance;
	delset(ins);
}

void
delay_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	DELAY * ins = (DELAY *)Instance;
	set_qcs_controlrate(SampleCount);
	delay(ins);
}

void
delay_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_delay_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "delay";
	d->Name = "delay";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 4;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="ar";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_AUDIO | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="asig";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[2]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[2]="idlt";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[2].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[3]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[3]="istor";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[3].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = DELAY_instantiate;
	d->connect_port = DELAY_connect_port;
	d->activate = delay_activate;
	d->run = delay_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = delay_cleanup;
	return d;
}

void
integ_activate(LADSPA_Handle Instance)
{
	INDIFF * ins = (INDIFF *)Instance;
	indfset(ins);
}

void
integ_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	INDIFF * ins = (INDIFF *)Instance;
	set_qcs_controlrate(SampleCount);
	integrate(ins);
}

void
integ_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_integ_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "integ";
	d->Name = "integ";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 3;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_CONTROL | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="rslt";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="xsig";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[2]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[2]="istor";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[2].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = INDIFF_instantiate;
	d->connect_port = INDIFF_connect_port;
	d->activate = integ_activate;
	d->run = integ_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = integ_cleanup;
	return d;
}

void
interp_activate(LADSPA_Handle Instance)
{
	INDIFF * ins = (INDIFF *)Instance;
	indfset(ins);
}

void
interp_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	INDIFF * ins = (INDIFF *)Instance;
	set_qcs_controlrate(SampleCount);
	interp(ins);
}

void
interp_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_interp_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "interp";
	d->Name = "interp";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 3;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="rslt";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="xsig";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[2]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[2]="istor";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[2].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = INDIFF_instantiate;
	d->connect_port = INDIFF_connect_port;
	d->activate = interp_activate;
	d->run = interp_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = interp_cleanup;
	return d;
}

void
delayr_activate(LADSPA_Handle Instance)
{
	DELAYR * ins = (DELAYR *)Instance;
	delrset(ins);
}

void
delayr_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	DELAYR * ins = (DELAYR *)Instance;
	set_qcs_controlrate(SampleCount);
	delayr(ins);
}

void
delayr_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_delayr_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "delayr";
	d->Name = "delayr";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 3;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="ar";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="idlt";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[2]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[2]="istor";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[2].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = DELAYR_instantiate;
	d->connect_port = DELAYR_connect_port;
	d->activate = delayr_activate;
	d->run = delayr_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = delayr_cleanup;
	return d;
}

void
delay1_activate(LADSPA_Handle Instance)
{
	DELAY1 * ins = (DELAY1 *)Instance;
	del1set(ins);
}

void
delay1_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	DELAY1 * ins = (DELAY1 *)Instance;
	set_qcs_controlrate(SampleCount);
	delay1(ins);
}

void
delay1_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_delay1_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "delay1";
	d->Name = "delay1";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 3;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="ar";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_AUDIO | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="asig";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[2]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[2]="istor";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[2].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = DELAY1_instantiate;
	d->connect_port = DELAY1_connect_port;
	d->activate = delay1_activate;
	d->run = delay1_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = delay1_cleanup;
	return d;
}

void
alpass_activate(LADSPA_Handle Instance)
{
	COMB * ins = (COMB *)Instance;
	cmbset(ins);
}

void
alpass_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	COMB * ins = (COMB *)Instance;
	set_qcs_controlrate(SampleCount);
	alpass(ins);
}

void
alpass_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_alpass_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "alpass";
	d->Name = "alpass";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 5;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="ar";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_AUDIO | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="asig";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[2]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[2]="krvt";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[2].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[3]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[3]="ilpt";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[3].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[4]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[4]="istor";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[4].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = COMB_instantiate;
	d->connect_port = COMB_connect_port;
	d->activate = alpass_activate;
	d->run = alpass_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = alpass_cleanup;
	return d;
}

void
delayw_activate(LADSPA_Handle Instance)
{
	DELAYW * ins = (DELAYW *)Instance;
	delwset(ins);
}

void
delayw_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	DELAYW * ins = (DELAYW *)Instance;
	set_qcs_controlrate(SampleCount);
	delayw(ins);
}

void
delayw_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_delayw_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "delayw";
	d->Name = "delayw";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 1;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[0]="asig";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = DELAYW_instantiate;
	d->connect_port = DELAYW_connect_port;
	d->activate = delayw_activate;
	d->run = delayw_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = delayw_cleanup;
	return d;
}

void
deltap_activate(LADSPA_Handle Instance)
{
	DELTAP * ins = (DELTAP *)Instance;
	tapset(ins);
}

void
deltap_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	DELTAP * ins = (DELTAP *)Instance;
	set_qcs_controlrate(SampleCount);
	deltap(ins);
}

void
deltap_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_deltap_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "deltap";
	d->Name = "deltap";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 2;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="ar";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="xdlt";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = DELTAP_instantiate;
	d->connect_port = DELTAP_connect_port;
	d->activate = deltap_activate;
	d->run = deltap_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = deltap_cleanup;
	return d;
}

enum descriptor_enum {
	pan_desc_enum, deltapi_desc_enum, comb_desc_enum, reverb_desc_enum, diff_desc_enum, samphold_desc_enum, delay_desc_enum, integ_desc_enum, interp_desc_enum, delayr_desc_enum, delay1_desc_enum, alpass_desc_enum, delayw_desc_enum, deltap_desc_enum, 
};

const LADSPA_Descriptor *
ladspa_descriptor(unsigned long Index)
{
	static bool inited=false;
	static LADSPA_Descriptor *pan_desc_pointer;
	static LADSPA_Descriptor *deltapi_desc_pointer;
	static LADSPA_Descriptor *comb_desc_pointer;
	static LADSPA_Descriptor *reverb_desc_pointer;
	static LADSPA_Descriptor *diff_desc_pointer;
	static LADSPA_Descriptor *samphold_desc_pointer;
	static LADSPA_Descriptor *delay_desc_pointer;
	static LADSPA_Descriptor *integ_desc_pointer;
	static LADSPA_Descriptor *interp_desc_pointer;
	static LADSPA_Descriptor *delayr_desc_pointer;
	static LADSPA_Descriptor *delay1_desc_pointer;
	static LADSPA_Descriptor *alpass_desc_pointer;
	static LADSPA_Descriptor *delayw_desc_pointer;
	static LADSPA_Descriptor *deltap_desc_pointer;

	if (!inited) {
		pan_desc_pointer = new_pan_desc();
		deltapi_desc_pointer = new_deltapi_desc();
		comb_desc_pointer = new_comb_desc();
		reverb_desc_pointer = new_reverb_desc();
		diff_desc_pointer = new_diff_desc();
		samphold_desc_pointer = new_samphold_desc();
		delay_desc_pointer = new_delay_desc();
		integ_desc_pointer = new_integ_desc();
		interp_desc_pointer = new_interp_desc();
		delayr_desc_pointer = new_delayr_desc();
		delay1_desc_pointer = new_delay1_desc();
		alpass_desc_pointer = new_alpass_desc();
		delayw_desc_pointer = new_delayw_desc();
		deltap_desc_pointer = new_deltap_desc();

		inited=true;
	}
	
	switch(Index) {
		case pan_desc_enum : return pan_desc_pointer;
		case deltapi_desc_enum : return deltapi_desc_pointer;
		case comb_desc_enum : return comb_desc_pointer;
		case reverb_desc_enum : return reverb_desc_pointer;
		case diff_desc_enum : return diff_desc_pointer;
		case samphold_desc_enum : return samphold_desc_pointer;
		case delay_desc_enum : return delay_desc_pointer;
		case integ_desc_enum : return integ_desc_pointer;
		case interp_desc_enum : return interp_desc_pointer;
		case delayr_desc_enum : return delayr_desc_pointer;
		case delay1_desc_enum : return delay1_desc_pointer;
		case alpass_desc_enum : return alpass_desc_pointer;
		case delayw_desc_enum : return delayw_desc_pointer;
		case deltap_desc_enum : return deltap_desc_pointer;

		default:
			return 0;
	}
}
