
#include "ladspa.h"

extern
void
set_qcs_framerate(unsigned long framerate);

extern
void
set_qcs_controlrate(unsigned long samplecount);
#include "turnoff.h"


LADSPA_Handle
TURNOFF_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	TURNOFF * i = new TURNOFF;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum TURNOFF_port_enum {
	TURNOFF_out_enum, TURNOFF_in_enum, TURNOFF_duration_enum, TURNOFF_threshold_enum, TURNOFF_enabled_enum, 
};

void
TURNOFF_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	TURNOFF * ins = (TURNOFF *)Instance;
	switch(Port) {

		case TURNOFF_out_enum:
			ins->out = DataLocation;
			break;

		case TURNOFF_in_enum:
			ins->in = DataLocation;
			break;

		case TURNOFF_duration_enum:
			ins->duration = DataLocation;
			break;

		case TURNOFF_threshold_enum:
			ins->threshold = DataLocation;
			break;

		case TURNOFF_enabled_enum:
			ins->enabled = DataLocation;
			break;

		default:
			break;
	}
}

LADSPA_Handle
BASIC_OP_ARG_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	BASIC_OP_ARG * i = new BASIC_OP_ARG;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum BASIC_OP_ARG_port_enum {
	
};

void
BASIC_OP_ARG_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	BASIC_OP_ARG * ins = (BASIC_OP_ARG *)Instance;
	switch(Port) {

		default:
			break;
	}
}

void
turnoff_activate(LADSPA_Handle Instance)
{
	TURNOFF * ins = (TURNOFF *)Instance;
	turnoff_set(ins);
}

void
turnoff_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	TURNOFF * ins = (TURNOFF *)Instance;
	set_qcs_controlrate(SampleCount);
	turnoff_audio(ins);
}

void
turnoff_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_turnoff_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "turnoff";
	d->Name = "turnoff";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 5;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="out";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_AUDIO | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="in";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[2]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[2]="duration";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[2].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[3]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[3]="threshold";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[3].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[4]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[4]="enabled";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[4].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = TURNOFF_instantiate;
	d->connect_port = TURNOFF_connect_port;
	d->activate = turnoff_activate;
	d->run = turnoff_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = turnoff_cleanup;
	return d;
}

enum descriptor_enum {
	turnoff_desc_enum, 
};

const LADSPA_Descriptor *
ladspa_descriptor(unsigned long Index)
{
	static bool inited=false;
	static LADSPA_Descriptor *turnoff_desc_pointer;

	if (!inited) {
		turnoff_desc_pointer = new_turnoff_desc();

		inited=true;
	}
	
	switch(Index) {
		case turnoff_desc_enum : return turnoff_desc_pointer;

		default:
			return 0;
	}
}
