
#include "ladspa.h"

extern
void
set_qcs_framerate(unsigned long framerate);

extern
void
set_qcs_controlrate(unsigned long samplecount);
#include "trigwait.h"


LADSPA_Handle
TRIGGER_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	TRIGGER * i = new TRIGGER;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum TRIGGER_port_enum {
	TRIGGER_ptr_enum, TRIGGER_val_enum, 
};

void
TRIGGER_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	TRIGGER * ins = (TRIGGER *)Instance;
	switch(Port) {

		case TRIGGER_ptr_enum:
			ins->ptr = DataLocation;
			break;

		case TRIGGER_val_enum:
			ins->val = DataLocation;
			break;

		default:
			break;
	}
}

LADSPA_Handle
TRIGGER_DELTA_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	TRIGGER_DELTA * i = new TRIGGER_DELTA;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum TRIGGER_DELTA_port_enum {
	TRIGGER_DELTA_ptr_enum, 
};

void
TRIGGER_DELTA_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	TRIGGER_DELTA * ins = (TRIGGER_DELTA *)Instance;
	switch(Port) {

		case TRIGGER_DELTA_ptr_enum:
			ins->ptr = DataLocation;
			break;

		default:
			break;
	}
}

LADSPA_Handle
BASIC_OP_ARG_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	BASIC_OP_ARG * i = new BASIC_OP_ARG;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum BASIC_OP_ARG_port_enum {
	
};

void
BASIC_OP_ARG_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	BASIC_OP_ARG * ins = (BASIC_OP_ARG *)Instance;
	switch(Port) {

		default:
			break;
	}
}

enum descriptor_enum {
	
};

const LADSPA_Descriptor *
ladspa_descriptor(unsigned long Index)
{
	static bool inited=false;

	if (!inited) {

		inited=true;
	}
	
	switch(Index) {

		default:
			return 0;
	}
}
