
#include "ladspa.h"

extern
void
set_qcs_framerate(unsigned long framerate);

extern
void
set_qcs_controlrate(unsigned long samplecount);
#include "spatializer2D.h"


LADSPA_Handle
SPATIALIZER2D_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	SPATIALIZER2D * i = new SPATIALIZER2D;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum SPATIALIZER2D_port_enum {
	SPATIALIZER2D_aleft_enum, SPATIALIZER2D_aright_enum, SPATIALIZER2D_ain_enum, SPATIALIZER2D_xpos_enum, SPATIALIZER2D_zpos_enum, 
};

void
SPATIALIZER2D_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	SPATIALIZER2D * ins = (SPATIALIZER2D *)Instance;
	switch(Port) {

		case SPATIALIZER2D_aleft_enum:
			ins->aleft = DataLocation;
			break;

		case SPATIALIZER2D_aright_enum:
			ins->aright = DataLocation;
			break;

		case SPATIALIZER2D_ain_enum:
			ins->ain = DataLocation;
			break;

		case SPATIALIZER2D_xpos_enum:
			ins->xpos = DataLocation;
			break;

		case SPATIALIZER2D_zpos_enum:
			ins->zpos = DataLocation;
			break;

		default:
			break;
	}
}

LADSPA_Handle
BASIC_OP_ARG_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	BASIC_OP_ARG * i = new BASIC_OP_ARG;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum BASIC_OP_ARG_port_enum {
	
};

void
BASIC_OP_ARG_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	BASIC_OP_ARG * ins = (BASIC_OP_ARG *)Instance;
	switch(Port) {

		default:
			break;
	}
}

void
spatializer2D_activate(LADSPA_Handle Instance)
{
	SPATIALIZER2D * ins = (SPATIALIZER2D *)Instance;
	spatializer2Dset(ins);
}

void
spatializer2D_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	SPATIALIZER2D * ins = (SPATIALIZER2D *)Instance;
	set_qcs_controlrate(SampleCount);
	spatializer2Da(ins);
}

void
spatializer2D_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_spatializer2D_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "spatializer2D";
	d->Name = "spatializer2D";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 5;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="aleft";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[1]="aright";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[2]=LADSPA_PORT_AUDIO | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[2]="ain";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[2].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[3]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[3]="xpos";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[3].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[4]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[4]="zpos";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[4].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = SPATIALIZER2D_instantiate;
	d->connect_port = SPATIALIZER2D_connect_port;
	d->activate = spatializer2D_activate;
	d->run = spatializer2D_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = spatializer2D_cleanup;
	return d;
}

enum descriptor_enum {
	spatializer2D_desc_enum, 
};

const LADSPA_Descriptor *
ladspa_descriptor(unsigned long Index)
{
	static bool inited=false;
	static LADSPA_Descriptor *spatializer2D_desc_pointer;

	if (!inited) {
		spatializer2D_desc_pointer = new_spatializer2D_desc();

		inited=true;
	}
	
	switch(Index) {
		case spatializer2D_desc_enum : return spatializer2D_desc_pointer;

		default:
			return 0;
	}
}
