
#include "ladspa.h"

extern
void
set_qcs_framerate(unsigned long framerate);

extern
void
set_qcs_controlrate(unsigned long samplecount);
#include "soundio.h"


LADSPA_Handle
INS_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	INS * i = new INS;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum INS_port_enum {
	INS_ar1_enum, INS_ar2_enum, 
};

void
INS_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	INS * ins = (INS *)Instance;
	switch(Port) {

		case INS_ar1_enum:
			ins->ar1 = DataLocation;
			break;

		case INS_ar2_enum:
			ins->ar2 = DataLocation;
			break;

		default:
			break;
	}
}

LADSPA_Handle
INQ_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	INQ * i = new INQ;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum INQ_port_enum {
	INQ_ar1_enum, INQ_ar2_enum, INQ_ar3_enum, INQ_ar4_enum, 
};

void
INQ_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	INQ * ins = (INQ *)Instance;
	switch(Port) {

		case INQ_ar1_enum:
			ins->ar1 = DataLocation;
			break;

		case INQ_ar2_enum:
			ins->ar2 = DataLocation;
			break;

		case INQ_ar3_enum:
			ins->ar3 = DataLocation;
			break;

		case INQ_ar4_enum:
			ins->ar4 = DataLocation;
			break;

		default:
			break;
	}
}

LADSPA_Handle
OUT_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	OUT * i = new OUT;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum OUT_port_enum {
	OUT_asig_enum, 
};

void
OUT_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	OUT * ins = (OUT *)Instance;
	switch(Port) {

		case OUT_asig_enum:
			ins->asig = DataLocation;
			break;

		default:
			break;
	}
}

LADSPA_Handle
OUTH_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	OUTH * i = new OUTH;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum OUTH_port_enum {
	OUTH_asig1_enum, OUTH_asig2_enum, OUTH_asig3_enum, OUTH_asig4_enum, OUTH_asig5_enum, OUTH_asig6_enum, 
};

void
OUTH_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	OUTH * ins = (OUTH *)Instance;
	switch(Port) {

		case OUTH_asig1_enum:
			ins->asig1 = DataLocation;
			break;

		case OUTH_asig2_enum:
			ins->asig2 = DataLocation;
			break;

		case OUTH_asig3_enum:
			ins->asig3 = DataLocation;
			break;

		case OUTH_asig4_enum:
			ins->asig4 = DataLocation;
			break;

		case OUTH_asig5_enum:
			ins->asig5 = DataLocation;
			break;

		case OUTH_asig6_enum:
			ins->asig6 = DataLocation;
			break;

		default:
			break;
	}
}

LADSPA_Handle
OUTQ_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	OUTQ * i = new OUTQ;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum OUTQ_port_enum {
	OUTQ_asig1_enum, OUTQ_asig2_enum, OUTQ_asig3_enum, OUTQ_asig4_enum, 
};

void
OUTQ_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	OUTQ * ins = (OUTQ *)Instance;
	switch(Port) {

		case OUTQ_asig1_enum:
			ins->asig1 = DataLocation;
			break;

		case OUTQ_asig2_enum:
			ins->asig2 = DataLocation;
			break;

		case OUTQ_asig3_enum:
			ins->asig3 = DataLocation;
			break;

		case OUTQ_asig4_enum:
			ins->asig4 = DataLocation;
			break;

		default:
			break;
	}
}

LADSPA_Handle
IN_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	IN * i = new IN;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum IN_port_enum {
	IN_ar_enum, 
};

void
IN_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	IN * ins = (IN *)Instance;
	switch(Port) {

		case IN_ar_enum:
			ins->ar = DataLocation;
			break;

		default:
			break;
	}
}

LADSPA_Handle
OUTS_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	OUTS * i = new OUTS;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum OUTS_port_enum {
	OUTS_asig1_enum, OUTS_asig2_enum, 
};

void
OUTS_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	OUTS * ins = (OUTS *)Instance;
	switch(Port) {

		case OUTS_asig1_enum:
			ins->asig1 = DataLocation;
			break;

		case OUTS_asig2_enum:
			ins->asig2 = DataLocation;
			break;

		default:
			break;
	}
}

LADSPA_Handle
INH_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	INH * i = new INH;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum INH_port_enum {
	INH_ar1_enum, INH_ar2_enum, INH_ar3_enum, INH_ar4_enum, INH_ar5_enum, INH_ar6_enum, 
};

void
INH_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	INH * ins = (INH *)Instance;
	switch(Port) {

		case INH_ar1_enum:
			ins->ar1 = DataLocation;
			break;

		case INH_ar2_enum:
			ins->ar2 = DataLocation;
			break;

		case INH_ar3_enum:
			ins->ar3 = DataLocation;
			break;

		case INH_ar4_enum:
			ins->ar4 = DataLocation;
			break;

		case INH_ar5_enum:
			ins->ar5 = DataLocation;
			break;

		case INH_ar6_enum:
			ins->ar6 = DataLocation;
			break;

		default:
			break;
	}
}

LADSPA_Handle
INO_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	INO * i = new INO;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum INO_port_enum {
	INO_ar1_enum, INO_ar2_enum, INO_ar3_enum, INO_ar4_enum, INO_ar5_enum, INO_ar6_enum, INO_ar7_enum, INO_ar8_enum, 
};

void
INO_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	INO * ins = (INO *)Instance;
	switch(Port) {

		case INO_ar1_enum:
			ins->ar1 = DataLocation;
			break;

		case INO_ar2_enum:
			ins->ar2 = DataLocation;
			break;

		case INO_ar3_enum:
			ins->ar3 = DataLocation;
			break;

		case INO_ar4_enum:
			ins->ar4 = DataLocation;
			break;

		case INO_ar5_enum:
			ins->ar5 = DataLocation;
			break;

		case INO_ar6_enum:
			ins->ar6 = DataLocation;
			break;

		case INO_ar7_enum:
			ins->ar7 = DataLocation;
			break;

		case INO_ar8_enum:
			ins->ar8 = DataLocation;
			break;

		default:
			break;
	}
}

LADSPA_Handle
BASIC_OP_ARG_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	BASIC_OP_ARG * i = new BASIC_OP_ARG;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum BASIC_OP_ARG_port_enum {
	
};

void
BASIC_OP_ARG_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	BASIC_OP_ARG * ins = (BASIC_OP_ARG *)Instance;
	switch(Port) {

		default:
			break;
	}
}

LADSPA_Handle
OUTO_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	OUTO * i = new OUTO;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum OUTO_port_enum {
	OUTO_asig1_enum, OUTO_asig2_enum, OUTO_asig3_enum, OUTO_asig4_enum, OUTO_asig5_enum, OUTO_asig6_enum, OUTO_asig7_enum, OUTO_asig8_enum, 
};

void
OUTO_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	OUTO * ins = (OUTO *)Instance;
	switch(Port) {

		case OUTO_asig1_enum:
			ins->asig1 = DataLocation;
			break;

		case OUTO_asig2_enum:
			ins->asig2 = DataLocation;
			break;

		case OUTO_asig3_enum:
			ins->asig3 = DataLocation;
			break;

		case OUTO_asig4_enum:
			ins->asig4 = DataLocation;
			break;

		case OUTO_asig5_enum:
			ins->asig5 = DataLocation;
			break;

		case OUTO_asig6_enum:
			ins->asig6 = DataLocation;
			break;

		case OUTO_asig7_enum:
			ins->asig7 = DataLocation;
			break;

		case OUTO_asig8_enum:
			ins->asig8 = DataLocation;
			break;

		default:
			break;
	}
}

void
out_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	OUT * ins = (OUT *)Instance;
	set_qcs_controlrate(SampleCount);
	out(ins);
}

void
out_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_out_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "out";
	d->Name = "out";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 1;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[0]="asig";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = OUT_instantiate;
	d->connect_port = OUT_connect_port;
	d->activate = 0;
	d->run = out_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = out_cleanup;
	return d;
}

void
outq4_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	OUT * ins = (OUT *)Instance;
	set_qcs_controlrate(SampleCount);
	outq4(ins);
}

void
outq4_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_outq4_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "outq4";
	d->Name = "outq4";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 1;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[0]="asig";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = OUT_instantiate;
	d->connect_port = OUT_connect_port;
	d->activate = 0;
	d->run = outq4_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = outq4_cleanup;
	return d;
}

void
outq2_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	OUT * ins = (OUT *)Instance;
	set_qcs_controlrate(SampleCount);
	outq2(ins);
}

void
outq2_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_outq2_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "outq2";
	d->Name = "outq2";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 1;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[0]="asig";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = OUT_instantiate;
	d->connect_port = OUT_connect_port;
	d->activate = 0;
	d->run = outq2_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = outq2_cleanup;
	return d;
}

void
outq1_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	OUT * ins = (OUT *)Instance;
	set_qcs_controlrate(SampleCount);
	outq1(ins);
}

void
outq1_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_outq1_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "outq1";
	d->Name = "outq1";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 1;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[0]="asig";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = OUT_instantiate;
	d->connect_port = OUT_connect_port;
	d->activate = 0;
	d->run = outq1_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = outq1_cleanup;
	return d;
}

void
outq3_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	OUT * ins = (OUT *)Instance;
	set_qcs_controlrate(SampleCount);
	outq3(ins);
}

void
outq3_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_outq3_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "outq3";
	d->Name = "outq3";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 1;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[0]="asig";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = OUT_instantiate;
	d->connect_port = OUT_connect_port;
	d->activate = 0;
	d->run = outq3_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = outq3_cleanup;
	return d;
}

void
in_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	IN * ins = (IN *)Instance;
	set_qcs_controlrate(SampleCount);
	in(ins);
}

void
in_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_in_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "in";
	d->Name = "in";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 1;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="ar";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = IN_instantiate;
	d->connect_port = IN_connect_port;
	d->activate = 0;
	d->run = in_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = in_cleanup;
	return d;
}

void
outs1_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	OUT * ins = (OUT *)Instance;
	set_qcs_controlrate(SampleCount);
	outs1(ins);
}

void
outs1_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_outs1_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "outs1";
	d->Name = "outs1";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 1;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[0]="asig";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = OUT_instantiate;
	d->connect_port = OUT_connect_port;
	d->activate = 0;
	d->run = outs1_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = outs1_cleanup;
	return d;
}

void
ins_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	INS * ins = (INS *)Instance;
	set_qcs_controlrate(SampleCount);
	ins(ins);
}

void
ins_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_ins_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "ins";
	d->Name = "ins";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 2;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="ar1";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[1]="ar2";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = INS_instantiate;
	d->connect_port = INS_connect_port;
	d->activate = 0;
	d->run = ins_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = ins_cleanup;
	return d;
}

void
inq_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	INQ * ins = (INQ *)Instance;
	set_qcs_controlrate(SampleCount);
	inq(ins);
}

void
inq_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_inq_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "inq";
	d->Name = "inq";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 4;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="ar1";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[1]="ar2";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[2]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[2]="ar3";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[2].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[3]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[3]="ar4";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[3].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = INQ_instantiate;
	d->connect_port = INQ_connect_port;
	d->activate = 0;
	d->run = inq_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = inq_cleanup;
	return d;
}

void
outs_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	OUTS * ins = (OUTS *)Instance;
	set_qcs_controlrate(SampleCount);
	outs(ins);
}

void
outs_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_outs_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "outs";
	d->Name = "outs";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 2;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[0]="asig1";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_AUDIO | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="asig2";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = OUTS_instantiate;
	d->connect_port = OUTS_connect_port;
	d->activate = 0;
	d->run = outs_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = outs_cleanup;
	return d;
}

void
outs2_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	OUT * ins = (OUT *)Instance;
	set_qcs_controlrate(SampleCount);
	outs2(ins);
}

void
outs2_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_outs2_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "outs2";
	d->Name = "outs2";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 1;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[0]="asig";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = OUT_instantiate;
	d->connect_port = OUT_connect_port;
	d->activate = 0;
	d->run = outs2_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = outs2_cleanup;
	return d;
}

void
outq_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	OUTQ * ins = (OUTQ *)Instance;
	set_qcs_controlrate(SampleCount);
	outq(ins);
}

void
outq_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_outq_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "outq";
	d->Name = "outq";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 4;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[0]="asig1";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_AUDIO | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="asig2";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[2]=LADSPA_PORT_AUDIO | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[2]="asig3";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[2].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[3]=LADSPA_PORT_AUDIO | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[3]="asig4";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[3].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = OUTQ_instantiate;
	d->connect_port = OUTQ_connect_port;
	d->activate = 0;
	d->run = outq_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = outq_cleanup;
	return d;
}

enum descriptor_enum {
	out_desc_enum, outq4_desc_enum, outq1_desc_enum, outq3_desc_enum, outq2_desc_enum, in_desc_enum, ins_desc_enum, inq_desc_enum, outq_desc_enum, outs_desc_enum, outs2_desc_enum, outs1_desc_enum, 
};

const LADSPA_Descriptor *
ladspa_descriptor(unsigned long Index)
{
	static bool inited=false;
	static LADSPA_Descriptor *out_desc_pointer;
	static LADSPA_Descriptor *outq4_desc_pointer;
	static LADSPA_Descriptor *outq1_desc_pointer;
	static LADSPA_Descriptor *outq3_desc_pointer;
	static LADSPA_Descriptor *outq2_desc_pointer;
	static LADSPA_Descriptor *in_desc_pointer;
	static LADSPA_Descriptor *ins_desc_pointer;
	static LADSPA_Descriptor *inq_desc_pointer;
	static LADSPA_Descriptor *outq_desc_pointer;
	static LADSPA_Descriptor *outs_desc_pointer;
	static LADSPA_Descriptor *outs2_desc_pointer;
	static LADSPA_Descriptor *outs1_desc_pointer;

	if (!inited) {
		out_desc_pointer = new_out_desc();
		outq4_desc_pointer = new_outq4_desc();
		outq1_desc_pointer = new_outq1_desc();
		outq3_desc_pointer = new_outq3_desc();
		outq2_desc_pointer = new_outq2_desc();
		in_desc_pointer = new_in_desc();
		ins_desc_pointer = new_ins_desc();
		inq_desc_pointer = new_inq_desc();
		outq_desc_pointer = new_outq_desc();
		outs_desc_pointer = new_outs_desc();
		outs2_desc_pointer = new_outs2_desc();
		outs1_desc_pointer = new_outs1_desc();

		inited=true;
	}
	
	switch(Index) {
		case out_desc_enum : return out_desc_pointer;
		case outq4_desc_enum : return outq4_desc_pointer;
		case outq1_desc_enum : return outq1_desc_pointer;
		case outq3_desc_enum : return outq3_desc_pointer;
		case outq2_desc_enum : return outq2_desc_pointer;
		case in_desc_enum : return in_desc_pointer;
		case ins_desc_enum : return ins_desc_pointer;
		case inq_desc_enum : return inq_desc_pointer;
		case outq_desc_enum : return outq_desc_pointer;
		case outs_desc_enum : return outs_desc_pointer;
		case outs2_desc_enum : return outs2_desc_pointer;
		case outs1_desc_enum : return outs1_desc_pointer;

		default:
			return 0;
	}
}
