
#include "ladspa.h"

extern
void
set_qcs_framerate(unsigned long framerate);

extern
void
set_qcs_controlrate(unsigned long samplecount);
#include "sndwarp.h"


LADSPA_Handle
SNDWARPST_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	SNDWARPST * i = new SNDWARPST;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum SNDWARPST_port_enum {
	SNDWARPST_r1_enum, SNDWARPST_r2_enum, SNDWARPST_r3_enum, SNDWARPST_r4_enum, SNDWARPST_xamp_enum, SNDWARPST_xtimewarp_enum, SNDWARPST_xresample_enum, SNDWARPST_isampfun_enum, SNDWARPST_ibegin_enum, SNDWARPST_iwsize_enum, SNDWARPST_irandw_enum, SNDWARPST_ioverlap_enum, SNDWARPST_ifn_enum, SNDWARPST_itimemode_enum, 
};

void
SNDWARPST_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	SNDWARPST * ins = (SNDWARPST *)Instance;
	switch(Port) {

		case SNDWARPST_r1_enum:
			ins->r1 = DataLocation;
			break;

		case SNDWARPST_r2_enum:
			ins->r2 = DataLocation;
			break;

		case SNDWARPST_r3_enum:
			ins->r3 = DataLocation;
			break;

		case SNDWARPST_r4_enum:
			ins->r4 = DataLocation;
			break;

		case SNDWARPST_xamp_enum:
			ins->xamp = DataLocation;
			break;

		case SNDWARPST_xtimewarp_enum:
			ins->xtimewarp = DataLocation;
			break;

		case SNDWARPST_xresample_enum:
			ins->xresample = DataLocation;
			break;

		case SNDWARPST_isampfun_enum:
			ins->isampfun = DataLocation;
			break;

		case SNDWARPST_ibegin_enum:
			ins->ibegin = DataLocation;
			break;

		case SNDWARPST_iwsize_enum:
			ins->iwsize = DataLocation;
			break;

		case SNDWARPST_irandw_enum:
			ins->irandw = DataLocation;
			break;

		case SNDWARPST_ioverlap_enum:
			ins->ioverlap = DataLocation;
			break;

		case SNDWARPST_ifn_enum:
			ins->ifn = DataLocation;
			break;

		case SNDWARPST_itimemode_enum:
			ins->itimemode = DataLocation;
			break;

		default:
			break;
	}
}

LADSPA_Handle
BASIC_OP_ARG_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	BASIC_OP_ARG * i = new BASIC_OP_ARG;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum BASIC_OP_ARG_port_enum {
	
};

void
BASIC_OP_ARG_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	BASIC_OP_ARG * ins = (BASIC_OP_ARG *)Instance;
	switch(Port) {

		default:
			break;
	}
}

LADSPA_Handle
SNDWARP_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	SNDWARP * i = new SNDWARP;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum SNDWARP_port_enum {
	SNDWARP_r1_enum, SNDWARP_r2_enum, SNDWARP_xamp_enum, SNDWARP_xtimewarp_enum, SNDWARP_xresample_enum, SNDWARP_isampfun_enum, SNDWARP_ibegin_enum, SNDWARP_iwsize_enum, SNDWARP_irandw_enum, SNDWARP_ioverlap_enum, SNDWARP_ifn_enum, SNDWARP_itimemode_enum, 
};

void
SNDWARP_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	SNDWARP * ins = (SNDWARP *)Instance;
	switch(Port) {

		case SNDWARP_r1_enum:
			ins->r1 = DataLocation;
			break;

		case SNDWARP_r2_enum:
			ins->r2 = DataLocation;
			break;

		case SNDWARP_xamp_enum:
			ins->xamp = DataLocation;
			break;

		case SNDWARP_xtimewarp_enum:
			ins->xtimewarp = DataLocation;
			break;

		case SNDWARP_xresample_enum:
			ins->xresample = DataLocation;
			break;

		case SNDWARP_isampfun_enum:
			ins->isampfun = DataLocation;
			break;

		case SNDWARP_ibegin_enum:
			ins->ibegin = DataLocation;
			break;

		case SNDWARP_iwsize_enum:
			ins->iwsize = DataLocation;
			break;

		case SNDWARP_irandw_enum:
			ins->irandw = DataLocation;
			break;

		case SNDWARP_ioverlap_enum:
			ins->ioverlap = DataLocation;
			break;

		case SNDWARP_ifn_enum:
			ins->ifn = DataLocation;
			break;

		case SNDWARP_itimemode_enum:
			ins->itimemode = DataLocation;
			break;

		default:
			break;
	}
}

void
sndwarpst_activate(LADSPA_Handle Instance)
{
	SNDWARPST * ins = (SNDWARPST *)Instance;
	sndwarpstset(ins);
}

void
sndwarpst_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	SNDWARPST * ins = (SNDWARPST *)Instance;
	set_qcs_controlrate(SampleCount);
	sndwarpst(ins);
}

void
sndwarpst_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_sndwarpst_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "sndwarpst";
	d->Name = "sndwarpst";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 14;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_CONTROL | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="r1";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_CONTROL | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[1]="r2";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[2]=LADSPA_PORT_CONTROL | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[2]="r3";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[2].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[3]=LADSPA_PORT_CONTROL | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[3]="r4";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[3].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[4]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[4]="xamp";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[4].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[5]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[5]="xtimewarp";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[5].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[6]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[6]="xresample";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[6].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[7]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[7]="isampfun";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[7].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[8]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[8]="ibegin";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[8].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[9]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[9]="iwsize";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[9].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[10]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[10]="irandw";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[10].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[11]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[11]="ioverlap";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[11].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[12]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[12]="ifn";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[12].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[13]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[13]="itimemode";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[13].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = SNDWARPST_instantiate;
	d->connect_port = SNDWARPST_connect_port;
	d->activate = sndwarpst_activate;
	d->run = sndwarpst_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = sndwarpst_cleanup;
	return d;
}

void
sndwarp_activate(LADSPA_Handle Instance)
{
	SNDWARP * ins = (SNDWARP *)Instance;
	sndwarpgetset(ins);
}

void
sndwarp_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	SNDWARP * ins = (SNDWARP *)Instance;
	set_qcs_controlrate(SampleCount);
	sndwarp(ins);
}

void
sndwarp_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_sndwarp_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "sndwarp";
	d->Name = "sndwarp";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 12;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_CONTROL | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="r1";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_CONTROL | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[1]="r2";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[2]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[2]="xamp";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[2].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[3]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[3]="xtimewarp";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[3].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[4]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[4]="xresample";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[4].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[5]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[5]="isampfun";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[5].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[6]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[6]="ibegin";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[6].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[7]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[7]="iwsize";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[7].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[8]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[8]="irandw";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[8].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[9]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[9]="ioverlap";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[9].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[10]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[10]="ifn";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[10].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[11]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[11]="itimemode";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[11].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = SNDWARP_instantiate;
	d->connect_port = SNDWARP_connect_port;
	d->activate = sndwarp_activate;
	d->run = sndwarp_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = sndwarp_cleanup;
	return d;
}

enum descriptor_enum {
	sndwarpst_desc_enum, sndwarp_desc_enum, 
};

const LADSPA_Descriptor *
ladspa_descriptor(unsigned long Index)
{
	static bool inited=false;
	static LADSPA_Descriptor *sndwarpst_desc_pointer;
	static LADSPA_Descriptor *sndwarp_desc_pointer;

	if (!inited) {
		sndwarpst_desc_pointer = new_sndwarpst_desc();
		sndwarp_desc_pointer = new_sndwarp_desc();

		inited=true;
	}
	
	switch(Index) {
		case sndwarpst_desc_enum : return sndwarpst_desc_pointer;
		case sndwarp_desc_enum : return sndwarp_desc_pointer;

		default:
			return 0;
	}
}
