
#include "ladspa.h"

extern
void
set_qcs_framerate(unsigned long framerate);

extern
void
set_qcs_controlrate(unsigned long samplecount);
#include "shaker.h"


LADSPA_Handle
SHAKER_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	SHAKER * i = new SHAKER;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum SHAKER_port_enum {
	SHAKER_ar_enum, SHAKER_amp_enum, SHAKER_kfreq_enum, SHAKER_beancount_enum, SHAKER_shake_damp_enum, SHAKER_times_enum, SHAKER_dettack_enum, 
};

void
SHAKER_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	SHAKER * ins = (SHAKER *)Instance;
	switch(Port) {

		case SHAKER_ar_enum:
			ins->ar = DataLocation;
			break;

		case SHAKER_amp_enum:
			ins->amp = DataLocation;
			break;

		case SHAKER_kfreq_enum:
			ins->kfreq = DataLocation;
			break;

		case SHAKER_beancount_enum:
			ins->beancount = DataLocation;
			break;

		case SHAKER_shake_damp_enum:
			ins->shake_damp = DataLocation;
			break;

		case SHAKER_times_enum:
			ins->times = DataLocation;
			break;

		case SHAKER_dettack_enum:
			ins->dettack = DataLocation;
			break;

		default:
			break;
	}
}

LADSPA_Handle
BASIC_OP_ARG_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	BASIC_OP_ARG * i = new BASIC_OP_ARG;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum BASIC_OP_ARG_port_enum {
	
};

void
BASIC_OP_ARG_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	BASIC_OP_ARG * ins = (BASIC_OP_ARG *)Instance;
	switch(Port) {

		default:
			break;
	}
}

void
shaker_activate(LADSPA_Handle Instance)
{
	SHAKER * ins = (SHAKER *)Instance;
	shakerset(ins);
}

void
shaker_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	SHAKER * ins = (SHAKER *)Instance;
	set_qcs_controlrate(SampleCount);
	shaker(ins);
}

void
shaker_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_shaker_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "shaker";
	d->Name = "shaker";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 7;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="ar";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="amp";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[2]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[2]="kfreq";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[2].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[3]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[3]="beancount";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[3].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[4]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[4]="shake_damp";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[4].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[5]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[5]="times";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[5].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[6]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[6]="dettack";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[6].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = SHAKER_instantiate;
	d->connect_port = SHAKER_connect_port;
	d->activate = shaker_activate;
	d->run = shaker_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = shaker_cleanup;
	return d;
}

enum descriptor_enum {
	shaker_desc_enum, 
};

const LADSPA_Descriptor *
ladspa_descriptor(unsigned long Index)
{
	static bool inited=false;
	static LADSPA_Descriptor *shaker_desc_pointer;

	if (!inited) {
		shaker_desc_pointer = new_shaker_desc();

		inited=true;
	}
	
	switch(Index) {
		case shaker_desc_enum : return shaker_desc_pointer;

		default:
			return 0;
	}
}
