
#include "ladspa.h"

extern
void
set_qcs_framerate(unsigned long framerate);

extern
void
set_qcs_controlrate(unsigned long samplecount);
#include "rtline.h"


LADSPA_Handle
RTLINE_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	RTLINE * i = new RTLINE;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum RTLINE_port_enum {
	RTLINE_kout_enum, RTLINE_start_enum, RTLINE_target_enum, RTLINE_duration_enum, 
};

void
RTLINE_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	RTLINE * ins = (RTLINE *)Instance;
	switch(Port) {

		case RTLINE_kout_enum:
			ins->kout = DataLocation;
			break;

		case RTLINE_start_enum:
			ins->start = DataLocation;
			break;

		case RTLINE_target_enum:
			ins->target = DataLocation;
			break;

		case RTLINE_duration_enum:
			ins->duration = DataLocation;
			break;

		default:
			break;
	}
}

LADSPA_Handle
BASIC_OP_ARG_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	BASIC_OP_ARG * i = new BASIC_OP_ARG;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum BASIC_OP_ARG_port_enum {
	
};

void
BASIC_OP_ARG_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	BASIC_OP_ARG * ins = (BASIC_OP_ARG *)Instance;
	switch(Port) {

		default:
			break;
	}
}

enum descriptor_enum {
	
};

const LADSPA_Descriptor *
ladspa_descriptor(unsigned long Index)
{
	static bool inited=false;

	if (!inited) {

		inited=true;
	}
	
	switch(Index) {

		default:
			return 0;
	}
}
