
#include "ladspa.h"

extern
void
set_qcs_framerate(unsigned long framerate);

extern
void
set_qcs_controlrate(unsigned long samplecount);
#include "printk.h"


LADSPA_Handle
TEXTMSG_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	TEXTMSG * i = new TEXTMSG;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum TEXTMSG_port_enum {
	TEXTMSG_args_enum, 
};

void
TEXTMSG_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	TEXTMSG * ins = (TEXTMSG *)Instance;
	switch(Port) {

		case TEXTMSG_args_enum:
			ins->args = DataLocation;
			break;

		default:
			break;
	}
}

LADSPA_Handle
PRINTA_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	PRINTA * i = new PRINTA;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum PRINTA_port_enum {
	PRINTA_ptime_enum, PRINTA_name_enum, PRINTA_val_enum, 
};

void
PRINTA_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	PRINTA * ins = (PRINTA *)Instance;
	switch(Port) {

		case PRINTA_ptime_enum:
			ins->ptime = DataLocation;
			break;

		case PRINTA_name_enum:
			ins->name = DataLocation;
			break;

		case PRINTA_val_enum:
			ins->val = DataLocation;
			break;

		default:
			break;
	}
}

LADSPA_Handle
BASIC_OP_ARG_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	BASIC_OP_ARG * i = new BASIC_OP_ARG;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum BASIC_OP_ARG_port_enum {
	
};

void
BASIC_OP_ARG_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	BASIC_OP_ARG * ins = (BASIC_OP_ARG *)Instance;
	switch(Port) {

		default:
			break;
	}
}

LADSPA_Handle
PRINTKD_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	PRINTKD * i = new PRINTKD;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum PRINTKD_port_enum {
	PRINTKD_pname_enum, PRINTKD_val_enum, 
};

void
PRINTKD_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	PRINTKD * ins = (PRINTKD *)Instance;
	switch(Port) {

		case PRINTKD_pname_enum:
			ins->pname = DataLocation;
			break;

		case PRINTKD_val_enum:
			ins->val = DataLocation;
			break;

		default:
			break;
	}
}

LADSPA_Handle
PRINTK_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	PRINTK * i = new PRINTK;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum PRINTK_port_enum {
	PRINTK_ptime_enum, PRINTK_val_enum, PRINTK_pspace_enum, 
};

void
PRINTK_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	PRINTK * ins = (PRINTK *)Instance;
	switch(Port) {

		case PRINTK_ptime_enum:
			ins->ptime = DataLocation;
			break;

		case PRINTK_val_enum:
			ins->val = DataLocation;
			break;

		case PRINTK_pspace_enum:
			ins->pspace = DataLocation;
			break;

		default:
			break;
	}
}

LADSPA_Handle
PRINTKS_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	PRINTKS * i = new PRINTKS;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum PRINTKS_port_enum {
	PRINTKS_ptime_enum, PRINTKS_fmt_enum, PRINTKS_args_enum, 
};

void
PRINTKS_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	PRINTKS * ins = (PRINTKS *)Instance;
	switch(Port) {

		case PRINTKS_ptime_enum:
			ins->ptime = DataLocation;
			break;

		case PRINTKS_fmt_enum:
			ins->fmt = DataLocation;
			break;

		case PRINTKS_args_enum:
			ins->args = DataLocation;
			break;

		default:
			break;
	}
}

enum descriptor_enum {
	
};

const LADSPA_Descriptor *
ladspa_descriptor(unsigned long Index)
{
	static bool inited=false;

	if (!inited) {

		inited=true;
	}
	
	switch(Index) {

		default:
			return 0;
	}
}
