
#include "ladspa.h"

extern
void
set_qcs_framerate(unsigned long framerate);

extern
void
set_qcs_controlrate(unsigned long samplecount);
#include "moog1.h"


LADSPA_Handle
MOOG1_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	MOOG1 * i = new MOOG1;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum MOOG1_port_enum {
	MOOG1_ar_enum, MOOG1_amp_enum, MOOG1_frequency_enum, MOOG1_filterQ_enum, MOOG1_filterRate_enum, MOOG1_vibf_enum, MOOG1_vibAmt_enum, MOOG1_iatt_enum, MOOG1_ifn_enum, MOOG1_ivfn_enum, 
};

void
MOOG1_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	MOOG1 * ins = (MOOG1 *)Instance;
	switch(Port) {

		case MOOG1_ar_enum:
			ins->ar = DataLocation;
			break;

		case MOOG1_amp_enum:
			ins->amp = DataLocation;
			break;

		case MOOG1_frequency_enum:
			ins->frequency = DataLocation;
			break;

		case MOOG1_filterQ_enum:
			ins->filterQ = DataLocation;
			break;

		case MOOG1_filterRate_enum:
			ins->filterRate = DataLocation;
			break;

		case MOOG1_vibf_enum:
			ins->vibf = DataLocation;
			break;

		case MOOG1_vibAmt_enum:
			ins->vibAmt = DataLocation;
			break;

		case MOOG1_iatt_enum:
			ins->iatt = DataLocation;
			break;

		case MOOG1_ifn_enum:
			ins->ifn = DataLocation;
			break;

		case MOOG1_ivfn_enum:
			ins->ivfn = DataLocation;
			break;

		default:
			break;
	}
}

LADSPA_Handle
BASIC_OP_ARG_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	BASIC_OP_ARG * i = new BASIC_OP_ARG;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum BASIC_OP_ARG_port_enum {
	
};

void
BASIC_OP_ARG_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	BASIC_OP_ARG * ins = (BASIC_OP_ARG *)Instance;
	switch(Port) {

		default:
			break;
	}
}

void
moog_activate(LADSPA_Handle Instance)
{
	MOOG1 * ins = (MOOG1 *)Instance;
	Moog1set(ins);
}

void
moog_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	MOOG1 * ins = (MOOG1 *)Instance;
	set_qcs_controlrate(SampleCount);
	Moog1(ins);
}

void
moog_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_moog_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "moog";
	d->Name = "moog";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 10;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="ar";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="amp";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[2]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[2]="frequency";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[2].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[3]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[3]="filterQ";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[3].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[4]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[4]="filterRate";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[4].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[5]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[5]="vibf";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[5].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[6]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[6]="vibAmt";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[6].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[7]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[7]="iatt";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[7].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[8]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[8]="ifn";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[8].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[9]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[9]="ivfn";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[9].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = MOOG1_instantiate;
	d->connect_port = MOOG1_connect_port;
	d->activate = moog_activate;
	d->run = moog_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = moog_cleanup;
	return d;
}

enum descriptor_enum {
	moog_desc_enum, 
};

const LADSPA_Descriptor *
ladspa_descriptor(unsigned long Index)
{
	static bool inited=false;
	static LADSPA_Descriptor *moog_desc_pointer;

	if (!inited) {
		moog_desc_pointer = new_moog_desc();

		inited=true;
	}
	
	switch(Index) {
		case moog_desc_enum : return moog_desc_pointer;

		default:
			return 0;
	}
}
