
#include "ladspa.h"

extern
void
set_qcs_framerate(unsigned long framerate);

extern
void
set_qcs_controlrate(unsigned long samplecount);
#include "midiout.h"


LADSPA_Handle
OUT_ON_DUR_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	OUT_ON_DUR * i = new OUT_ON_DUR;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum OUT_ON_DUR_port_enum {
	OUT_ON_DUR_ichn_enum, OUT_ON_DUR_inum_enum, OUT_ON_DUR_ivel_enum, OUT_ON_DUR_idur_enum, 
};

void
OUT_ON_DUR_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	OUT_ON_DUR * ins = (OUT_ON_DUR *)Instance;
	switch(Port) {

		case OUT_ON_DUR_ichn_enum:
			ins->ichn = DataLocation;
			break;

		case OUT_ON_DUR_inum_enum:
			ins->inum = DataLocation;
			break;

		case OUT_ON_DUR_ivel_enum:
			ins->ivel = DataLocation;
			break;

		case OUT_ON_DUR_idur_enum:
			ins->idur = DataLocation;
			break;

		default:
			break;
	}
}

LADSPA_Handle
OUT_POLYATOUCH_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	OUT_POLYATOUCH * i = new OUT_POLYATOUCH;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum OUT_POLYATOUCH_port_enum {
	OUT_POLYATOUCH_chn_enum, OUT_POLYATOUCH_num_enum, OUT_POLYATOUCH_value_enum, OUT_POLYATOUCH_min_enum, OUT_POLYATOUCH_max_enum, 
};

void
OUT_POLYATOUCH_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	OUT_POLYATOUCH * ins = (OUT_POLYATOUCH *)Instance;
	switch(Port) {

		case OUT_POLYATOUCH_chn_enum:
			ins->chn = DataLocation;
			break;

		case OUT_POLYATOUCH_num_enum:
			ins->num = DataLocation;
			break;

		case OUT_POLYATOUCH_value_enum:
			ins->value = DataLocation;
			break;

		case OUT_POLYATOUCH_min_enum:
			ins->min = DataLocation;
			break;

		case OUT_POLYATOUCH_max_enum:
			ins->max = DataLocation;
			break;

		default:
			break;
	}
}

LADSPA_Handle
OUT_CONTR_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	OUT_CONTR * i = new OUT_CONTR;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum OUT_CONTR_port_enum {
	OUT_CONTR_chn_enum, OUT_CONTR_num_enum, OUT_CONTR_value_enum, OUT_CONTR_min_enum, OUT_CONTR_max_enum, 
};

void
OUT_CONTR_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	OUT_CONTR * ins = (OUT_CONTR *)Instance;
	switch(Port) {

		case OUT_CONTR_chn_enum:
			ins->chn = DataLocation;
			break;

		case OUT_CONTR_num_enum:
			ins->num = DataLocation;
			break;

		case OUT_CONTR_value_enum:
			ins->value = DataLocation;
			break;

		case OUT_CONTR_min_enum:
			ins->min = DataLocation;
			break;

		case OUT_CONTR_max_enum:
			ins->max = DataLocation;
			break;

		default:
			break;
	}
}

LADSPA_Handle
MDELAY_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	MDELAY * i = new MDELAY;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum MDELAY_port_enum {
	MDELAY_in_status_enum, MDELAY_in_chan_enum, MDELAY_in_dat1_enum, MDELAY_in_dat2_enum, MDELAY_kdelay_enum, 
};

void
MDELAY_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	MDELAY * ins = (MDELAY *)Instance;
	switch(Port) {

		case MDELAY_in_status_enum:
			ins->in_status = DataLocation;
			break;

		case MDELAY_in_chan_enum:
			ins->in_chan = DataLocation;
			break;

		case MDELAY_in_dat1_enum:
			ins->in_dat1 = DataLocation;
			break;

		case MDELAY_in_dat2_enum:
			ins->in_dat2 = DataLocation;
			break;

		case MDELAY_kdelay_enum:
			ins->kdelay = DataLocation;
			break;

		default:
			break;
	}
}

LADSPA_Handle
OUT_PB_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	OUT_PB * i = new OUT_PB;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum OUT_PB_port_enum {
	OUT_PB_chn_enum, OUT_PB_value_enum, OUT_PB_min_enum, OUT_PB_max_enum, 
};

void
OUT_PB_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	OUT_PB * ins = (OUT_PB *)Instance;
	switch(Port) {

		case OUT_PB_chn_enum:
			ins->chn = DataLocation;
			break;

		case OUT_PB_value_enum:
			ins->value = DataLocation;
			break;

		case OUT_PB_min_enum:
			ins->min = DataLocation;
			break;

		case OUT_PB_max_enum:
			ins->max = DataLocation;
			break;

		default:
			break;
	}
}

LADSPA_Handle
MCLOCK_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	MCLOCK * i = new MCLOCK;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum MCLOCK_port_enum {
	MCLOCK_freq_enum, 
};

void
MCLOCK_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	MCLOCK * ins = (MCLOCK *)Instance;
	switch(Port) {

		case MCLOCK_freq_enum:
			ins->freq = DataLocation;
			break;

		default:
			break;
	}
}

LADSPA_Handle
DELTAB_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	DELTAB * i = new DELTAB;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum DELTAB_port_enum {
	
};

void
DELTAB_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	DELTAB * ins = (DELTAB *)Instance;
	switch(Port) {

		default:
			break;
	}
}

LADSPA_Handle
OUT_PCHG_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	OUT_PCHG * i = new OUT_PCHG;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum OUT_PCHG_port_enum {
	OUT_PCHG_chn_enum, OUT_PCHG_prog_num_enum, OUT_PCHG_min_enum, OUT_PCHG_max_enum, 
};

void
OUT_PCHG_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	OUT_PCHG * ins = (OUT_PCHG *)Instance;
	switch(Port) {

		case OUT_PCHG_chn_enum:
			ins->chn = DataLocation;
			break;

		case OUT_PCHG_prog_num_enum:
			ins->prog_num = DataLocation;
			break;

		case OUT_PCHG_min_enum:
			ins->min = DataLocation;
			break;

		case OUT_PCHG_max_enum:
			ins->max = DataLocation;
			break;

		default:
			break;
	}
}

LADSPA_Handle
OUT_ATOUCH_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	OUT_ATOUCH * i = new OUT_ATOUCH;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum OUT_ATOUCH_port_enum {
	OUT_ATOUCH_chn_enum, OUT_ATOUCH_value_enum, OUT_ATOUCH_min_enum, OUT_ATOUCH_max_enum, 
};

void
OUT_ATOUCH_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	OUT_ATOUCH * ins = (OUT_ATOUCH *)Instance;
	switch(Port) {

		case OUT_ATOUCH_chn_enum:
			ins->chn = DataLocation;
			break;

		case OUT_ATOUCH_value_enum:
			ins->value = DataLocation;
			break;

		case OUT_ATOUCH_min_enum:
			ins->min = DataLocation;
			break;

		case OUT_ATOUCH_max_enum:
			ins->max = DataLocation;
			break;

		default:
			break;
	}
}

LADSPA_Handle
BASIC_OP_ARG_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	BASIC_OP_ARG * i = new BASIC_OP_ARG;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum BASIC_OP_ARG_port_enum {
	
};

void
BASIC_OP_ARG_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	BASIC_OP_ARG * ins = (BASIC_OP_ARG *)Instance;
	switch(Port) {

		default:
			break;
	}
}

LADSPA_Handle
NRPN_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	NRPN * i = new NRPN;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum NRPN_port_enum {
	NRPN_chan_enum, NRPN_parm_num_enum, NRPN_parm_value_enum, 
};

void
NRPN_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	NRPN * ins = (NRPN *)Instance;
	switch(Port) {

		case NRPN_chan_enum:
			ins->chan = DataLocation;
			break;

		case NRPN_parm_num_enum:
			ins->parm_num = DataLocation;
			break;

		case NRPN_parm_value_enum:
			ins->parm_value = DataLocation;
			break;

		default:
			break;
	}
}

LADSPA_Handle
MRT_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	MRT * i = new MRT;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum MRT_port_enum {
	MRT_message_enum, 
};

void
MRT_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	MRT * ins = (MRT *)Instance;
	switch(Port) {

		case MRT_message_enum:
			ins->message = DataLocation;
			break;

		default:
			break;
	}
}

LADSPA_Handle
OUT_CONTR14_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	OUT_CONTR14 * i = new OUT_CONTR14;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum OUT_CONTR14_port_enum {
	OUT_CONTR14_chn_enum, OUT_CONTR14_msb_num_enum, OUT_CONTR14_lsb_num_enum, OUT_CONTR14_value_enum, OUT_CONTR14_min_enum, OUT_CONTR14_max_enum, 
};

void
OUT_CONTR14_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	OUT_CONTR14 * ins = (OUT_CONTR14 *)Instance;
	switch(Port) {

		case OUT_CONTR14_chn_enum:
			ins->chn = DataLocation;
			break;

		case OUT_CONTR14_msb_num_enum:
			ins->msb_num = DataLocation;
			break;

		case OUT_CONTR14_lsb_num_enum:
			ins->lsb_num = DataLocation;
			break;

		case OUT_CONTR14_value_enum:
			ins->value = DataLocation;
			break;

		case OUT_CONTR14_min_enum:
			ins->min = DataLocation;
			break;

		case OUT_CONTR14_max_enum:
			ins->max = DataLocation;
			break;

		default:
			break;
	}
}

LADSPA_Handle
MIDIOUT_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	MIDIOUT * i = new MIDIOUT;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum MIDIOUT_port_enum {
	MIDIOUT_in_type_enum, MIDIOUT_in_chan_enum, MIDIOUT_in_dat1_enum, MIDIOUT_in_dat2_enum, 
};

void
MIDIOUT_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	MIDIOUT * ins = (MIDIOUT *)Instance;
	switch(Port) {

		case MIDIOUT_in_type_enum:
			ins->in_type = DataLocation;
			break;

		case MIDIOUT_in_chan_enum:
			ins->in_chan = DataLocation;
			break;

		case MIDIOUT_in_dat1_enum:
			ins->in_dat1 = DataLocation;
			break;

		case MIDIOUT_in_dat2_enum:
			ins->in_dat2 = DataLocation;
			break;

		default:
			break;
	}
}

LADSPA_Handle
MOSCIL_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	MOSCIL * i = new MOSCIL;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum MOSCIL_port_enum {
	MOSCIL_kchn_enum, MOSCIL_knum_enum, MOSCIL_kvel_enum, MOSCIL_kdur_enum, MOSCIL_kpause_enum, 
};

void
MOSCIL_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	MOSCIL * ins = (MOSCIL *)Instance;
	switch(Port) {

		case MOSCIL_kchn_enum:
			ins->kchn = DataLocation;
			break;

		case MOSCIL_knum_enum:
			ins->knum = DataLocation;
			break;

		case MOSCIL_kvel_enum:
			ins->kvel = DataLocation;
			break;

		case MOSCIL_kdur_enum:
			ins->kdur = DataLocation;
			break;

		case MOSCIL_kpause_enum:
			ins->kpause = DataLocation;
			break;

		default:
			break;
	}
}

LADSPA_Handle
OUT_ON_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	OUT_ON * i = new OUT_ON;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum OUT_ON_port_enum {
	OUT_ON_ichn_enum, OUT_ON_inum_enum, OUT_ON_ivel_enum, 
};

void
OUT_ON_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	OUT_ON * ins = (OUT_ON *)Instance;
	switch(Port) {

		case OUT_ON_ichn_enum:
			ins->ichn = DataLocation;
			break;

		case OUT_ON_inum_enum:
			ins->inum = DataLocation;
			break;

		case OUT_ON_ivel_enum:
			ins->ivel = DataLocation;
			break;

		default:
			break;
	}
}

LADSPA_Handle
MIDION2_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	MIDION2 * i = new MIDION2;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum MIDION2_port_enum {
	MIDION2_kchn_enum, MIDION2_knum_enum, MIDION2_kvel_enum, MIDION2_ktrig_enum, 
};

void
MIDION2_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	MIDION2 * ins = (MIDION2 *)Instance;
	switch(Port) {

		case MIDION2_kchn_enum:
			ins->kchn = DataLocation;
			break;

		case MIDION2_knum_enum:
			ins->knum = DataLocation;
			break;

		case MIDION2_kvel_enum:
			ins->kvel = DataLocation;
			break;

		case MIDION2_ktrig_enum:
			ins->ktrig = DataLocation;
			break;

		default:
			break;
	}
}

LADSPA_Handle
KOUT_ON_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	KOUT_ON * i = new KOUT_ON;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum KOUT_ON_port_enum {
	KOUT_ON_kchn_enum, KOUT_ON_knum_enum, KOUT_ON_kvel_enum, 
};

void
KOUT_ON_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	KOUT_ON * ins = (KOUT_ON *)Instance;
	switch(Port) {

		case KOUT_ON_kchn_enum:
			ins->kchn = DataLocation;
			break;

		case KOUT_ON_knum_enum:
			ins->knum = DataLocation;
			break;

		case KOUT_ON_kvel_enum:
			ins->kvel = DataLocation;
			break;

		default:
			break;
	}
}

enum descriptor_enum {
	
};

const LADSPA_Descriptor *
ladspa_descriptor(unsigned long Index)
{
	static bool inited=false;

	if (!inited) {

		inited=true;
	}
	
	switch(Index) {

		default:
			return 0;
	}
}
