
#include "ladspa.h"

extern
void
set_qcs_framerate(unsigned long framerate);

extern
void
set_qcs_controlrate(unsigned long samplecount);
#include "midiops.h"


LADSPA_Handle
MIDIVAL_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	MIDIVAL * i = new MIDIVAL;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum MIDIVAL_port_enum {
	MIDIVAL_r_enum, MIDIVAL_irange_enum, 
};

void
MIDIVAL_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	MIDIVAL * ins = (MIDIVAL *)Instance;
	switch(Port) {

		case MIDIVAL_r_enum:
			ins->r = DataLocation;
			break;

		case MIDIVAL_irange_enum:
			ins->irange = DataLocation;
			break;

		default:
			break;
	}
}

LADSPA_Handle
CPSTABLE_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	CPSTABLE * i = new CPSTABLE;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum CPSTABLE_port_enum {
	CPSTABLE_r_enum, CPSTABLE_tablenum_enum, 
};

void
CPSTABLE_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	CPSTABLE * ins = (CPSTABLE *)Instance;
	switch(Port) {

		case CPSTABLE_r_enum:
			ins->r = DataLocation;
			break;

		case CPSTABLE_tablenum_enum:
			ins->tablenum = DataLocation;
			break;

		default:
			break;
	}
}

LADSPA_Handle
MIDIKMAP_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	MIDIKMAP * i = new MIDIKMAP;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum MIDIKMAP_port_enum {
	MIDIKMAP_r_enum, MIDIKMAP_ilo_enum, MIDIKMAP_ihi_enum, 
};

void
MIDIKMAP_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	MIDIKMAP * ins = (MIDIKMAP *)Instance;
	switch(Port) {

		case MIDIKMAP_r_enum:
			ins->r = DataLocation;
			break;

		case MIDIKMAP_ilo_enum:
			ins->ilo = DataLocation;
			break;

		case MIDIKMAP_ihi_enum:
			ins->ihi = DataLocation;
			break;

		default:
			break;
	}
}

LADSPA_Handle
MIDICTL_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	MIDICTL * i = new MIDICTL;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum MIDICTL_port_enum {
	MIDICTL_r_enum, MIDICTL_ictlno_enum, MIDICTL_ilo_enum, MIDICTL_ihi_enum, 
};

void
MIDICTL_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	MIDICTL * ins = (MIDICTL *)Instance;
	switch(Port) {

		case MIDICTL_r_enum:
			ins->r = DataLocation;
			break;

		case MIDICTL_ictlno_enum:
			ins->ictlno = DataLocation;
			break;

		case MIDICTL_ilo_enum:
			ins->ilo = DataLocation;
			break;

		case MIDICTL_ihi_enum:
			ins->ihi = DataLocation;
			break;

		default:
			break;
	}
}

LADSPA_Handle
BASIC_OP_ARG_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	BASIC_OP_ARG * i = new BASIC_OP_ARG;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum BASIC_OP_ARG_port_enum {
	
};

void
BASIC_OP_ARG_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	BASIC_OP_ARG * ins = (BASIC_OP_ARG *)Instance;
	switch(Port) {

		default:
			break;
	}
}

LADSPA_Handle
MIDIMAP_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	MIDIMAP * i = new MIDIMAP;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum MIDIMAP_port_enum {
	MIDIMAP_r_enum, MIDIMAP_ilo_enum, MIDIMAP_ihi_enum, 
};

void
MIDIMAP_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	MIDIMAP * ins = (MIDIMAP *)Instance;
	switch(Port) {

		case MIDIMAP_r_enum:
			ins->r = DataLocation;
			break;

		case MIDIMAP_ilo_enum:
			ins->ilo = DataLocation;
			break;

		case MIDIMAP_ihi_enum:
			ins->ihi = DataLocation;
			break;

		default:
			break;
	}
}

LADSPA_Handle
MASSIGN_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	MASSIGN * i = new MASSIGN;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum MASSIGN_port_enum {
	MASSIGN_chnl_enum, MASSIGN_module_id_enum, 
};

void
MASSIGN_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	MASSIGN * ins = (MASSIGN *)Instance;
	switch(Port) {

		case MASSIGN_chnl_enum:
			ins->chnl = DataLocation;
			break;

		case MASSIGN_module_id_enum:
			ins->module_id = DataLocation;
			break;

		default:
			break;
	}
}

LADSPA_Handle
MIDISCL_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	MIDISCL * i = new MIDISCL;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum MIDISCL_port_enum {
	MIDISCL_r_enum, MIDISCL_iscal_enum, 
};

void
MIDISCL_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	MIDISCL * ins = (MIDISCL *)Instance;
	switch(Port) {

		case MIDISCL_r_enum:
			ins->r = DataLocation;
			break;

		case MIDISCL_iscal_enum:
			ins->iscal = DataLocation;
			break;

		default:
			break;
	}
}

LADSPA_Handle
MIDIOLAP_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	MIDIOLAP * i = new MIDIOLAP;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum MIDIOLAP_port_enum {
	MIDIOLAP_olap_enum, 
};

void
MIDIOLAP_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	MIDIOLAP * ins = (MIDIOLAP *)Instance;
	switch(Port) {

		case MIDIOLAP_olap_enum:
			ins->olap = DataLocation;
			break;

		default:
			break;
	}
}

LADSPA_Handle
MIDIAMP_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	MIDIAMP * i = new MIDIAMP;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum MIDIAMP_port_enum {
	MIDIAMP_r_enum, MIDIAMP_imax_enum, MIDIAMP_ifn_enum, 
};

void
MIDIAMP_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	MIDIAMP * ins = (MIDIAMP *)Instance;
	switch(Port) {

		case MIDIAMP_r_enum:
			ins->r = DataLocation;
			break;

		case MIDIAMP_imax_enum:
			ins->imax = DataLocation;
			break;

		case MIDIAMP_ifn_enum:
			ins->ifn = DataLocation;
			break;

		default:
			break;
	}
}

LADSPA_Handle
MIDIAGE_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	MIDIAGE * i = new MIDIAGE;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum MIDIAGE_port_enum {
	MIDIAGE_r_enum, 
};

void
MIDIAGE_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	MIDIAGE * ins = (MIDIAGE *)Instance;
	switch(Port) {

		case MIDIAGE_r_enum:
			ins->r = DataLocation;
			break;

		default:
			break;
	}
}

LADSPA_Handle
CHANCTL_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	CHANCTL * i = new CHANCTL;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum CHANCTL_port_enum {
	CHANCTL_r_enum, CHANCTL_ichano_enum, CHANCTL_ictlno_enum, CHANCTL_ilo_enum, CHANCTL_ihi_enum, 
};

void
CHANCTL_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	CHANCTL * ins = (CHANCTL *)Instance;
	switch(Port) {

		case CHANCTL_r_enum:
			ins->r = DataLocation;
			break;

		case CHANCTL_ichano_enum:
			ins->ichano = DataLocation;
			break;

		case CHANCTL_ictlno_enum:
			ins->ictlno = DataLocation;
			break;

		case CHANCTL_ilo_enum:
			ins->ilo = DataLocation;
			break;

		case CHANCTL_ihi_enum:
			ins->ihi = DataLocation;
			break;

		default:
			break;
	}
}

LADSPA_Handle
CTLINIT_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	CTLINIT * i = new CTLINIT;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum CTLINIT_port_enum {
	CTLINIT_chnl_enum, CTLINIT_ctrls_enum, 
};

void
CTLINIT_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	CTLINIT * ins = (CTLINIT *)Instance;
	switch(Port) {

		case CTLINIT_chnl_enum:
			ins->chnl = DataLocation;
			break;

		case CTLINIT_ctrls_enum:
			ins->ctrls = DataLocation;
			break;

		default:
			break;
	}
}

enum descriptor_enum {
	
};

const LADSPA_Descriptor *
ladspa_descriptor(unsigned long Index)
{
	static bool inited=false;

	if (!inited) {

		inited=true;
	}
	
	switch(Index) {

		default:
			return 0;
	}
}
