
#include "ladspa.h"

extern
void
set_qcs_framerate(unsigned long framerate);

extern
void
set_qcs_controlrate(unsigned long samplecount);
#include "mandolin.h"


LADSPA_Handle
MANDOL_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	MANDOL * i = new MANDOL;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum MANDOL_port_enum {
	MANDOL_ar_enum, MANDOL_amp_enum, MANDOL_frequency_enum, MANDOL_pluckPos_enum, MANDOL_detuning_enum, MANDOL_baseLoopGain_enum, MANDOL_s_rate_enum, MANDOL_ifn_enum, MANDOL_lowestFreq_enum, 
};

void
MANDOL_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	MANDOL * ins = (MANDOL *)Instance;
	switch(Port) {

		case MANDOL_ar_enum:
			ins->ar = DataLocation;
			break;

		case MANDOL_amp_enum:
			ins->amp = DataLocation;
			break;

		case MANDOL_frequency_enum:
			ins->frequency = DataLocation;
			break;

		case MANDOL_pluckPos_enum:
			ins->pluckPos = DataLocation;
			break;

		case MANDOL_detuning_enum:
			ins->detuning = DataLocation;
			break;

		case MANDOL_baseLoopGain_enum:
			ins->baseLoopGain = DataLocation;
			break;

		case MANDOL_s_rate_enum:
			ins->s_rate = DataLocation;
			break;

		case MANDOL_ifn_enum:
			ins->ifn = DataLocation;
			break;

		case MANDOL_lowestFreq_enum:
			ins->lowestFreq = DataLocation;
			break;

		default:
			break;
	}
}

LADSPA_Handle
BASIC_OP_ARG_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	BASIC_OP_ARG * i = new BASIC_OP_ARG;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum BASIC_OP_ARG_port_enum {
	
};

void
BASIC_OP_ARG_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	BASIC_OP_ARG * ins = (BASIC_OP_ARG *)Instance;
	switch(Port) {

		default:
			break;
	}
}

void
mandol_activate(LADSPA_Handle Instance)
{
	MANDOL * ins = (MANDOL *)Instance;
	mandolinset(ins);
}

void
mandol_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	MANDOL * ins = (MANDOL *)Instance;
	set_qcs_controlrate(SampleCount);
	mandolin(ins);
}

void
mandol_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_mandol_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "mandol";
	d->Name = "mandol";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 9;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="ar";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="amp";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[2]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[2]="frequency";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[2].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[3]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[3]="pluckPos";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[3].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[4]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[4]="detuning";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[4].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[5]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[5]="baseLoopGain";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[5].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[6]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[6]="s_rate";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[6].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[7]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[7]="ifn";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[7].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[8]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[8]="lowestFreq";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[8].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = MANDOL_instantiate;
	d->connect_port = MANDOL_connect_port;
	d->activate = mandol_activate;
	d->run = mandol_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = mandol_cleanup;
	return d;
}

enum descriptor_enum {
	mandol_desc_enum, 
};

const LADSPA_Descriptor *
ladspa_descriptor(unsigned long Index)
{
	static bool inited=false;
	static LADSPA_Descriptor *mandol_desc_pointer;

	if (!inited) {
		mandol_desc_pointer = new_mandol_desc();

		inited=true;
	}
	
	switch(Index) {
		case mandol_desc_enum : return mandol_desc_pointer;

		default:
			return 0;
	}
}
