
#include "ladspa.h"

extern
void
set_qcs_framerate(unsigned long framerate);

extern
void
set_qcs_controlrate(unsigned long samplecount);
#include "lfo.h"


LADSPA_Handle
LFO_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	LFO * i = new LFO;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum LFO_port_enum {
	LFO_res_enum, LFO_kamp_enum, LFO_xcps_enum, LFO_type_enum, 
};

void
LFO_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	LFO * ins = (LFO *)Instance;
	switch(Port) {

		case LFO_res_enum:
			ins->res = DataLocation;
			break;

		case LFO_kamp_enum:
			ins->kamp = DataLocation;
			break;

		case LFO_xcps_enum:
			ins->xcps = DataLocation;
			break;

		case LFO_type_enum:
			ins->type = DataLocation;
			break;

		default:
			break;
	}
}

LADSPA_Handle
BASIC_OP_ARG_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	BASIC_OP_ARG * i = new BASIC_OP_ARG;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum BASIC_OP_ARG_port_enum {
	
};

void
BASIC_OP_ARG_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	BASIC_OP_ARG * ins = (BASIC_OP_ARG *)Instance;
	switch(Port) {

		default:
			break;
	}
}

void
lfo_activate(LADSPA_Handle Instance)
{
	LFO * ins = (LFO *)Instance;
	lfoset(ins);
}

void
lfo_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	LFO * ins = (LFO *)Instance;
	set_qcs_controlrate(SampleCount);
	lfoa(ins);
}

void
lfo_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_lfo_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "lfo";
	d->Name = "lfo";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 4;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_CONTROL | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="res";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="kamp";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[2]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[2]="xcps";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[2].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[3]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[3]="type";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[3].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = LFO_instantiate;
	d->connect_port = LFO_connect_port;
	d->activate = lfo_activate;
	d->run = lfo_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = lfo_cleanup;
	return d;
}

enum descriptor_enum {
	lfo_desc_enum, 
};

const LADSPA_Descriptor *
ladspa_descriptor(unsigned long Index)
{
	static bool inited=false;
	static LADSPA_Descriptor *lfo_desc_pointer;

	if (!inited) {
		lfo_desc_pointer = new_lfo_desc();

		inited=true;
	}
	
	switch(Index) {
		case lfo_desc_enum : return lfo_desc_pointer;

		default:
			return 0;
	}
}
