
#include "ladspa.h"

extern
void
set_qcs_framerate(unsigned long framerate);

extern
void
set_qcs_controlrate(unsigned long samplecount);
#include "harmon.h"


LADSPA_Handle
HARMON_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	HARMON * i = new HARMON;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum HARMON_port_enum {
	HARMON_ar_enum, HARMON_asig_enum, HARMON_kest_enum, HARMON_kvar_enum, HARMON_kfrq1_enum, HARMON_kfrq2_enum, HARMON_icpsmode_enum, HARMON_ilowest_enum, HARMON_iptrkprd_enum, 
};

void
HARMON_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	HARMON * ins = (HARMON *)Instance;
	switch(Port) {

		case HARMON_ar_enum:
			ins->ar = DataLocation;
			break;

		case HARMON_asig_enum:
			ins->asig = DataLocation;
			break;

		case HARMON_kest_enum:
			ins->kest = DataLocation;
			break;

		case HARMON_kvar_enum:
			ins->kvar = DataLocation;
			break;

		case HARMON_kfrq1_enum:
			ins->kfrq1 = DataLocation;
			break;

		case HARMON_kfrq2_enum:
			ins->kfrq2 = DataLocation;
			break;

		case HARMON_icpsmode_enum:
			ins->icpsmode = DataLocation;
			break;

		case HARMON_ilowest_enum:
			ins->ilowest = DataLocation;
			break;

		case HARMON_iptrkprd_enum:
			ins->iptrkprd = DataLocation;
			break;

		default:
			break;
	}
}

LADSPA_Handle
BASIC_OP_ARG_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	BASIC_OP_ARG * i = new BASIC_OP_ARG;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum BASIC_OP_ARG_port_enum {
	
};

void
BASIC_OP_ARG_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	BASIC_OP_ARG * ins = (BASIC_OP_ARG *)Instance;
	switch(Port) {

		default:
			break;
	}
}

void
harmon_activate(LADSPA_Handle Instance)
{
	HARMON * ins = (HARMON *)Instance;
	harmset(ins);
}

void
harmon_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	HARMON * ins = (HARMON *)Instance;
	set_qcs_controlrate(SampleCount);
	harmon(ins);
}

void
harmon_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_harmon_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "harmon";
	d->Name = "harmon";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 9;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="ar";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_AUDIO | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="asig";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[2]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[2]="kest";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[2].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[3]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[3]="kvar";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[3].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[4]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[4]="kfrq1";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[4].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[5]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[5]="kfrq2";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[5].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[6]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[6]="icpsmode";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[6].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[7]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[7]="ilowest";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[7].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[8]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[8]="iptrkprd";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[8].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = HARMON_instantiate;
	d->connect_port = HARMON_connect_port;
	d->activate = harmon_activate;
	d->run = harmon_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = harmon_cleanup;
	return d;
}

enum descriptor_enum {
	harmon_desc_enum, 
};

const LADSPA_Descriptor *
ladspa_descriptor(unsigned long Index)
{
	static bool inited=false;
	static LADSPA_Descriptor *harmon_desc_pointer;

	if (!inited) {
		harmon_desc_pointer = new_harmon_desc();

		inited=true;
	}
	
	switch(Index) {
		case harmon_desc_enum : return harmon_desc_pointer;

		default:
			return 0;
	}
}
