
#include "ladspa.h"

extern
void
set_qcs_framerate(unsigned long framerate);

extern
void
set_qcs_controlrate(unsigned long samplecount);
#include "ftgen.h"


LADSPA_Handle
BASIC_OP_ARG_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	BASIC_OP_ARG * i = new BASIC_OP_ARG;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum BASIC_OP_ARG_port_enum {
	
};

void
BASIC_OP_ARG_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	BASIC_OP_ARG * ins = (BASIC_OP_ARG *)Instance;
	switch(Port) {

		default:
			break;
	}
}

LADSPA_Handle
FTGEN_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	FTGEN * i = new FTGEN;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum FTGEN_port_enum {
	FTGEN_tablename_enum, FTGEN_starttime_enum, FTGEN_tablesize_enum, FTGEN_generator_enum, FTGEN_args_enum, 
};

void
FTGEN_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	FTGEN * ins = (FTGEN *)Instance;
	switch(Port) {

		case FTGEN_tablename_enum:
			ins->tablename = DataLocation;
			break;

		case FTGEN_starttime_enum:
			ins->starttime = DataLocation;
			break;

		case FTGEN_tablesize_enum:
			ins->tablesize = DataLocation;
			break;

		case FTGEN_generator_enum:
			ins->generator = DataLocation;
			break;

		case FTGEN_args_enum:
			ins->args = DataLocation;
			break;

		default:
			break;
	}
}

enum descriptor_enum {
	
};

const LADSPA_Descriptor *
ladspa_descriptor(unsigned long Index)
{
	static bool inited=false;

	if (!inited) {

		inited=true;
	}
	
	switch(Index) {

		default:
			return 0;
	}
}
