
#include "ladspa.h"

extern
void
set_qcs_framerate(unsigned long framerate);

extern
void
set_qcs_controlrate(unsigned long samplecount);
#include "fm4op.h"


LADSPA_Handle
FM4OP_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	FM4OP * i = new FM4OP;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum FM4OP_port_enum {
	FM4OP_ar_enum, FM4OP_amp_enum, FM4OP_frequency_enum, FM4OP_control1_enum, FM4OP_control2_enum, FM4OP_modDepth_enum, FM4OP_vibFreq_enum, FM4OP_ifn0_enum, FM4OP_ifn1_enum, FM4OP_ifn2_enum, FM4OP_ifn3_enum, FM4OP_vifn_enum, 
};

void
FM4OP_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	FM4OP * ins = (FM4OP *)Instance;
	switch(Port) {

		case FM4OP_ar_enum:
			ins->ar = DataLocation;
			break;

		case FM4OP_amp_enum:
			ins->amp = DataLocation;
			break;

		case FM4OP_frequency_enum:
			ins->frequency = DataLocation;
			break;

		case FM4OP_control1_enum:
			ins->control1 = DataLocation;
			break;

		case FM4OP_control2_enum:
			ins->control2 = DataLocation;
			break;

		case FM4OP_modDepth_enum:
			ins->modDepth = DataLocation;
			break;

		case FM4OP_vibFreq_enum:
			ins->vibFreq = DataLocation;
			break;

		case FM4OP_ifn0_enum:
			ins->ifn0 = DataLocation;
			break;

		case FM4OP_ifn1_enum:
			ins->ifn1 = DataLocation;
			break;

		case FM4OP_ifn2_enum:
			ins->ifn2 = DataLocation;
			break;

		case FM4OP_ifn3_enum:
			ins->ifn3 = DataLocation;
			break;

		case FM4OP_vifn_enum:
			ins->vifn = DataLocation;
			break;

		default:
			break;
	}
}

LADSPA_Handle
BASIC_OP_ARG_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	BASIC_OP_ARG * i = new BASIC_OP_ARG;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum BASIC_OP_ARG_port_enum {
	
};

void
BASIC_OP_ARG_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	BASIC_OP_ARG * ins = (BASIC_OP_ARG *)Instance;
	switch(Port) {

		default:
			break;
	}
}

LADSPA_Handle
FM4OPV_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	FM4OPV * i = new FM4OPV;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum FM4OPV_port_enum {
	FM4OPV_ar_enum, FM4OPV_amp_enum, FM4OPV_frequency_enum, FM4OPV_control1_enum, FM4OPV_control2_enum, FM4OPV_modDepth_enum, FM4OPV_vibFreq_enum, FM4OPV_ifn0_enum, FM4OPV_ifn1_enum, FM4OPV_ifn2_enum, FM4OPV_ifn3_enum, FM4OPV_vifn_enum, 
};

void
FM4OPV_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	FM4OPV * ins = (FM4OPV *)Instance;
	switch(Port) {

		case FM4OPV_ar_enum:
			ins->ar = DataLocation;
			break;

		case FM4OPV_amp_enum:
			ins->amp = DataLocation;
			break;

		case FM4OPV_frequency_enum:
			ins->frequency = DataLocation;
			break;

		case FM4OPV_control1_enum:
			ins->control1 = DataLocation;
			break;

		case FM4OPV_control2_enum:
			ins->control2 = DataLocation;
			break;

		case FM4OPV_modDepth_enum:
			ins->modDepth = DataLocation;
			break;

		case FM4OPV_vibFreq_enum:
			ins->vibFreq = DataLocation;
			break;

		case FM4OPV_ifn0_enum:
			ins->ifn0 = DataLocation;
			break;

		case FM4OPV_ifn1_enum:
			ins->ifn1 = DataLocation;
			break;

		case FM4OPV_ifn2_enum:
			ins->ifn2 = DataLocation;
			break;

		case FM4OPV_ifn3_enum:
			ins->ifn3 = DataLocation;
			break;

		case FM4OPV_vifn_enum:
			ins->vifn = DataLocation;
			break;

		default:
			break;
	}
}

void
fmwurlie_activate(LADSPA_Handle Instance)
{
	FM4OP * ins = (FM4OP *)Instance;
	wurleyset(ins);
}

void
fmwurlie_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	FM4OP * ins = (FM4OP *)Instance;
	set_qcs_controlrate(SampleCount);
	wurley(ins);
}

void
fmwurlie_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_fmwurlie_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "fmwurlie";
	d->Name = "fmwurlie";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 12;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="ar";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="amp";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[2]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[2]="frequency";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[2].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[3]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[3]="control1";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[3].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[4]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[4]="control2";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[4].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[5]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[5]="modDepth";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[5].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[6]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[6]="vibFreq";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[6].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[7]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[7]="ifn0";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[7].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[8]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[8]="ifn1";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[8].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[9]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[9]="ifn2";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[9].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[10]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[10]="ifn3";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[10].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[11]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[11]="vifn";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[11].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = FM4OP_instantiate;
	d->connect_port = FM4OP_connect_port;
	d->activate = fmwurlie_activate;
	d->run = fmwurlie_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = fmwurlie_cleanup;
	return d;
}

void
fmrhode_activate(LADSPA_Handle Instance)
{
	FM4OP * ins = (FM4OP *)Instance;
	rhodeset(ins);
}

void
fmrhode_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	FM4OP * ins = (FM4OP *)Instance;
	set_qcs_controlrate(SampleCount);
	tubebell(ins);
}

void
fmrhode_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_fmrhode_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "fmrhode";
	d->Name = "fmrhode";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 12;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="ar";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="amp";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[2]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[2]="frequency";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[2].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[3]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[3]="control1";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[3].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[4]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[4]="control2";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[4].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[5]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[5]="modDepth";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[5].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[6]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[6]="vibFreq";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[6].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[7]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[7]="ifn0";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[7].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[8]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[8]="ifn1";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[8].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[9]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[9]="ifn2";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[9].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[10]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[10]="ifn3";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[10].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[11]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[11]="vifn";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[11].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = FM4OP_instantiate;
	d->connect_port = FM4OP_connect_port;
	d->activate = fmrhode_activate;
	d->run = fmrhode_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = fmrhode_cleanup;
	return d;
}

void
fmvoice_activate(LADSPA_Handle Instance)
{
	FM4OPV * ins = (FM4OPV *)Instance;
	FMVoiceset(ins);
}

void
fmvoice_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	FM4OPV * ins = (FM4OPV *)Instance;
	set_qcs_controlrate(SampleCount);
	FMVoice(ins);
}

void
fmvoice_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_fmvoice_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "fmvoice";
	d->Name = "fmvoice";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 12;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="ar";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="amp";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[2]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[2]="frequency";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[2].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[3]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[3]="control1";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[3].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[4]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[4]="control2";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[4].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[5]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[5]="modDepth";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[5].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[6]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[6]="vibFreq";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[6].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[7]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[7]="ifn0";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[7].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[8]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[8]="ifn1";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[8].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[9]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[9]="ifn2";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[9].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[10]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[10]="ifn3";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[10].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[11]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[11]="vifn";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[11].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = FM4OPV_instantiate;
	d->connect_port = FM4OPV_connect_port;
	d->activate = fmvoice_activate;
	d->run = fmvoice_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = fmvoice_cleanup;
	return d;
}

void
fmmetal_activate(LADSPA_Handle Instance)
{
	FM4OP * ins = (FM4OP *)Instance;
	heavymetset(ins);
}

void
fmmetal_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	FM4OP * ins = (FM4OP *)Instance;
	set_qcs_controlrate(SampleCount);
	heavymet(ins);
}

void
fmmetal_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_fmmetal_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "fmmetal";
	d->Name = "fmmetal";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 12;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="ar";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="amp";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[2]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[2]="frequency";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[2].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[3]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[3]="control1";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[3].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[4]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[4]="control2";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[4].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[5]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[5]="modDepth";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[5].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[6]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[6]="vibFreq";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[6].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[7]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[7]="ifn0";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[7].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[8]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[8]="ifn1";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[8].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[9]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[9]="ifn2";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[9].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[10]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[10]="ifn3";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[10].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[11]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[11]="vifn";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[11].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = FM4OP_instantiate;
	d->connect_port = FM4OP_connect_port;
	d->activate = fmmetal_activate;
	d->run = fmmetal_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = fmmetal_cleanup;
	return d;
}

void
fmb3_activate(LADSPA_Handle Instance)
{
	FM4OP * ins = (FM4OP *)Instance;
	b3set(ins);
}

void
fmb3_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	FM4OP * ins = (FM4OP *)Instance;
	set_qcs_controlrate(SampleCount);
	hammondB3(ins);
}

void
fmb3_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_fmb3_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "fmb3";
	d->Name = "fmb3";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 12;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="ar";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="amp";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[2]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[2]="frequency";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[2].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[3]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[3]="control1";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[3].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[4]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[4]="control2";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[4].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[5]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[5]="modDepth";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[5].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[6]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[6]="vibFreq";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[6].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[7]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[7]="ifn0";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[7].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[8]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[8]="ifn1";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[8].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[9]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[9]="ifn2";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[9].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[10]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[10]="ifn3";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[10].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[11]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[11]="vifn";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[11].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = FM4OP_instantiate;
	d->connect_port = FM4OP_connect_port;
	d->activate = fmb3_activate;
	d->run = fmb3_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = fmb3_cleanup;
	return d;
}

void
fmbell_activate(LADSPA_Handle Instance)
{
	FM4OP * ins = (FM4OP *)Instance;
	tubebellset(ins);
}

void
fmbell_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	FM4OP * ins = (FM4OP *)Instance;
	set_qcs_controlrate(SampleCount);
	tubebell(ins);
}

void
fmbell_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_fmbell_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "fmbell";
	d->Name = "fmbell";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 12;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="ar";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="amp";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[2]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[2]="frequency";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[2].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[3]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[3]="control1";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[3].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[4]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[4]="control2";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[4].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[5]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[5]="modDepth";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[5].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[6]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[6]="vibFreq";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[6].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[7]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[7]="ifn0";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[7].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[8]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[8]="ifn1";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[8].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[9]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[9]="ifn2";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[9].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[10]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[10]="ifn3";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[10].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[11]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[11]="vifn";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[11].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = FM4OP_instantiate;
	d->connect_port = FM4OP_connect_port;
	d->activate = fmbell_activate;
	d->run = fmbell_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = fmbell_cleanup;
	return d;
}

void
fmpercfl_activate(LADSPA_Handle Instance)
{
	FM4OP * ins = (FM4OP *)Instance;
	percfluteset(ins);
}

void
fmpercfl_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	FM4OP * ins = (FM4OP *)Instance;
	set_qcs_controlrate(SampleCount);
	percflute(ins);
}

void
fmpercfl_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_fmpercfl_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "fmpercfl";
	d->Name = "fmpercfl";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 12;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="ar";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="amp";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[2]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[2]="frequency";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[2].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[3]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[3]="control1";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[3].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[4]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[4]="control2";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[4].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[5]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[5]="modDepth";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[5].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[6]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[6]="vibFreq";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[6].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[7]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[7]="ifn0";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[7].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[8]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[8]="ifn1";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[8].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[9]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[9]="ifn2";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[9].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[10]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[10]="ifn3";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[10].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[11]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[11]="vifn";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[11].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = FM4OP_instantiate;
	d->connect_port = FM4OP_connect_port;
	d->activate = fmpercfl_activate;
	d->run = fmpercfl_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = fmpercfl_cleanup;
	return d;
}

enum descriptor_enum {
	fmwurlie_desc_enum, fmrhode_desc_enum, fmvoice_desc_enum, fmmetal_desc_enum, fmb3_desc_enum, fmbell_desc_enum, fmpercfl_desc_enum, 
};

const LADSPA_Descriptor *
ladspa_descriptor(unsigned long Index)
{
	static bool inited=false;
	static LADSPA_Descriptor *fmwurlie_desc_pointer;
	static LADSPA_Descriptor *fmrhode_desc_pointer;
	static LADSPA_Descriptor *fmvoice_desc_pointer;
	static LADSPA_Descriptor *fmmetal_desc_pointer;
	static LADSPA_Descriptor *fmb3_desc_pointer;
	static LADSPA_Descriptor *fmbell_desc_pointer;
	static LADSPA_Descriptor *fmpercfl_desc_pointer;

	if (!inited) {
		fmwurlie_desc_pointer = new_fmwurlie_desc();
		fmrhode_desc_pointer = new_fmrhode_desc();
		fmvoice_desc_pointer = new_fmvoice_desc();
		fmmetal_desc_pointer = new_fmmetal_desc();
		fmb3_desc_pointer = new_fmb3_desc();
		fmbell_desc_pointer = new_fmbell_desc();
		fmpercfl_desc_pointer = new_fmpercfl_desc();

		inited=true;
	}
	
	switch(Index) {
		case fmwurlie_desc_enum : return fmwurlie_desc_pointer;
		case fmrhode_desc_enum : return fmrhode_desc_pointer;
		case fmvoice_desc_enum : return fmvoice_desc_pointer;
		case fmmetal_desc_enum : return fmmetal_desc_pointer;
		case fmb3_desc_enum : return fmb3_desc_pointer;
		case fmbell_desc_enum : return fmbell_desc_pointer;
		case fmpercfl_desc_enum : return fmpercfl_desc_pointer;

		default:
			return 0;
	}
}
