
#include "ladspa.h"

extern
void
set_qcs_framerate(unsigned long framerate);

extern
void
set_qcs_controlrate(unsigned long samplecount);
#include "flute.h"


LADSPA_Handle
FLUTE_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	FLUTE * i = new FLUTE;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum FLUTE_port_enum {
	FLUTE_ar_enum, FLUTE_amp_enum, FLUTE_frequency_enum, FLUTE_jetRatio_enum, FLUTE_attack_enum, FLUTE_dettack_enum, FLUTE_noiseGain_enum, FLUTE_vibFreq_enum, FLUTE_vibAmt_enum, FLUTE_ifn_enum, FLUTE_lowestFreq_enum, FLUTE_jetRefl_enum, FLUTE_endRefl_enum, 
};

void
FLUTE_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	FLUTE * ins = (FLUTE *)Instance;
	switch(Port) {

		case FLUTE_ar_enum:
			ins->ar = DataLocation;
			break;

		case FLUTE_amp_enum:
			ins->amp = DataLocation;
			break;

		case FLUTE_frequency_enum:
			ins->frequency = DataLocation;
			break;

		case FLUTE_jetRatio_enum:
			ins->jetRatio = DataLocation;
			break;

		case FLUTE_attack_enum:
			ins->attack = DataLocation;
			break;

		case FLUTE_dettack_enum:
			ins->dettack = DataLocation;
			break;

		case FLUTE_noiseGain_enum:
			ins->noiseGain = DataLocation;
			break;

		case FLUTE_vibFreq_enum:
			ins->vibFreq = DataLocation;
			break;

		case FLUTE_vibAmt_enum:
			ins->vibAmt = DataLocation;
			break;

		case FLUTE_ifn_enum:
			ins->ifn = DataLocation;
			break;

		case FLUTE_lowestFreq_enum:
			ins->lowestFreq = DataLocation;
			break;

		case FLUTE_jetRefl_enum:
			ins->jetRefl = DataLocation;
			break;

		case FLUTE_endRefl_enum:
			ins->endRefl = DataLocation;
			break;

		default:
			break;
	}
}

LADSPA_Handle
BASIC_OP_ARG_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	BASIC_OP_ARG * i = new BASIC_OP_ARG;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum BASIC_OP_ARG_port_enum {
	
};

void
BASIC_OP_ARG_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	BASIC_OP_ARG * ins = (BASIC_OP_ARG *)Instance;
	switch(Port) {

		default:
			break;
	}
}

void
wgflute_activate(LADSPA_Handle Instance)
{
	FLUTE * ins = (FLUTE *)Instance;
	fluteset(ins);
}

void
wgflute_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	FLUTE * ins = (FLUTE *)Instance;
	set_qcs_controlrate(SampleCount);
	flute(ins);
}

void
wgflute_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_wgflute_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "wgflute";
	d->Name = "wgflute";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 13;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="ar";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="amp";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[2]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[2]="frequency";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[2].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[3]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[3]="jetRatio";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[3].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[4]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[4]="attack";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[4].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[5]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[5]="dettack";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[5].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[6]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[6]="noiseGain";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[6].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[7]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[7]="vibFreq";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[7].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[8]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[8]="vibAmt";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[8].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[9]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[9]="ifn";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[9].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[10]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[10]="lowestFreq";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[10].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[11]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[11]="jetRefl";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[11].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[12]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[12]="endRefl";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[12].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = FLUTE_instantiate;
	d->connect_port = FLUTE_connect_port;
	d->activate = wgflute_activate;
	d->run = wgflute_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = wgflute_cleanup;
	return d;
}

enum descriptor_enum {
	wgflute_desc_enum, 
};

const LADSPA_Descriptor *
ladspa_descriptor(unsigned long Index)
{
	static bool inited=false;
	static LADSPA_Descriptor *wgflute_desc_pointer;

	if (!inited) {
		wgflute_desc_pointer = new_wgflute_desc();

		inited=true;
	}
	
	switch(Index) {
		case wgflute_desc_enum : return wgflute_desc_pointer;

		default:
			return 0;
	}
}
