
#include "ladspa.h"

extern
void
set_qcs_framerate(unsigned long framerate);

extern
void
set_qcs_controlrate(unsigned long samplecount);
#include "flanger.h"


LADSPA_Handle
WGUIDE2_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	WGUIDE2 * i = new WGUIDE2;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum WGUIDE2_port_enum {
	WGUIDE2_ar_enum, WGUIDE2_asig_enum, WGUIDE2_xdel1_enum, WGUIDE2_xdel2_enum, WGUIDE2_filt_khp1_enum, WGUIDE2_filt_khp2_enum, WGUIDE2_kfeedback1_enum, WGUIDE2_kfeedback2_enum, 
};

void
WGUIDE2_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	WGUIDE2 * ins = (WGUIDE2 *)Instance;
	switch(Port) {

		case WGUIDE2_ar_enum:
			ins->ar = DataLocation;
			break;

		case WGUIDE2_asig_enum:
			ins->asig = DataLocation;
			break;

		case WGUIDE2_xdel1_enum:
			ins->xdel1 = DataLocation;
			break;

		case WGUIDE2_xdel2_enum:
			ins->xdel2 = DataLocation;
			break;

		case WGUIDE2_filt_khp1_enum:
			ins->filt_khp1 = DataLocation;
			break;

		case WGUIDE2_filt_khp2_enum:
			ins->filt_khp2 = DataLocation;
			break;

		case WGUIDE2_kfeedback1_enum:
			ins->kfeedback1 = DataLocation;
			break;

		case WGUIDE2_kfeedback2_enum:
			ins->kfeedback2 = DataLocation;
			break;

		default:
			break;
	}
}

LADSPA_Handle
WGUIDE1_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	WGUIDE1 * i = new WGUIDE1;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum WGUIDE1_port_enum {
	WGUIDE1_ar_enum, WGUIDE1_asig_enum, WGUIDE1_xdel_enum, WGUIDE1_filt_khp_enum, WGUIDE1_kfeedback_enum, 
};

void
WGUIDE1_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	WGUIDE1 * ins = (WGUIDE1 *)Instance;
	switch(Port) {

		case WGUIDE1_ar_enum:
			ins->ar = DataLocation;
			break;

		case WGUIDE1_asig_enum:
			ins->asig = DataLocation;
			break;

		case WGUIDE1_xdel_enum:
			ins->xdel = DataLocation;
			break;

		case WGUIDE1_filt_khp_enum:
			ins->filt_khp = DataLocation;
			break;

		case WGUIDE1_kfeedback_enum:
			ins->kfeedback = DataLocation;
			break;

		default:
			break;
	}
}

LADSPA_Handle
FLANGER_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	FLANGER * i = new FLANGER;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum FLANGER_port_enum {
	FLANGER_ar_enum, FLANGER_asig_enum, FLANGER_xdel_enum, FLANGER_kfeedback_enum, FLANGER_maxd_enum, 
};

void
FLANGER_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	FLANGER * ins = (FLANGER *)Instance;
	switch(Port) {

		case FLANGER_ar_enum:
			ins->ar = DataLocation;
			break;

		case FLANGER_asig_enum:
			ins->asig = DataLocation;
			break;

		case FLANGER_xdel_enum:
			ins->xdel = DataLocation;
			break;

		case FLANGER_kfeedback_enum:
			ins->kfeedback = DataLocation;
			break;

		case FLANGER_maxd_enum:
			ins->maxd = DataLocation;
			break;

		default:
			break;
	}
}

LADSPA_Handle
BASIC_OP_ARG_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	BASIC_OP_ARG * i = new BASIC_OP_ARG;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum BASIC_OP_ARG_port_enum {
	
};

void
BASIC_OP_ARG_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	BASIC_OP_ARG * ins = (BASIC_OP_ARG *)Instance;
	switch(Port) {

		default:
			break;
	}
}

void
flanger_activate(LADSPA_Handle Instance)
{
	FLANGER * ins = (FLANGER *)Instance;
	flanger_set(ins);
}

void
flanger_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	FLANGER * ins = (FLANGER *)Instance;
	set_qcs_controlrate(SampleCount);
	flanger(ins);
}

void
flanger_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_flanger_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "flanger";
	d->Name = "flanger";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 5;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="ar";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_AUDIO | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="asig";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[2]=LADSPA_PORT_AUDIO | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[2]="xdel";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[2].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[3]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[3]="kfeedback";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[3].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[4]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[4]="maxd";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[4].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = FLANGER_instantiate;
	d->connect_port = FLANGER_connect_port;
	d->activate = flanger_activate;
	d->run = flanger_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = flanger_cleanup;
	return d;
}

enum descriptor_enum {
	flanger_desc_enum, 
};

const LADSPA_Descriptor *
ladspa_descriptor(unsigned long Index)
{
	static bool inited=false;
	static LADSPA_Descriptor *flanger_desc_pointer;

	if (!inited) {
		flanger_desc_pointer = new_flanger_desc();

		inited=true;
	}
	
	switch(Index) {
		case flanger_desc_enum : return flanger_desc_pointer;

		default:
			return 0;
	}
}
