
#include "ladspa.h"

extern
void
set_qcs_framerate(unsigned long framerate);

extern
void
set_qcs_controlrate(unsigned long samplecount);
#include "filter.h"


LADSPA_Handle
ZFILTER_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	ZFILTER * i = new ZFILTER;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum ZFILTER_port_enum {
	ZFILTER_out_enum, ZFILTER_in_enum, ZFILTER_kmagf_enum, ZFILTER_kphsf_enum, ZFILTER_nb_enum, ZFILTER_na_enum, ZFILTER_coeffs_enum, 
};

void
ZFILTER_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	ZFILTER * ins = (ZFILTER *)Instance;
	switch(Port) {

		case ZFILTER_out_enum:
			ins->out = DataLocation;
			break;

		case ZFILTER_in_enum:
			ins->in = DataLocation;
			break;

		case ZFILTER_kmagf_enum:
			ins->kmagf = DataLocation;
			break;

		case ZFILTER_kphsf_enum:
			ins->kphsf = DataLocation;
			break;

		case ZFILTER_nb_enum:
			ins->nb = DataLocation;
			break;

		case ZFILTER_na_enum:
			ins->na = DataLocation;
			break;

		case ZFILTER_coeffs_enum:
			ins->coeffs = DataLocation;
			break;

		default:
			break;
	}
}

LADSPA_Handle
BASIC_OP_ARG_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	BASIC_OP_ARG * i = new BASIC_OP_ARG;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum BASIC_OP_ARG_port_enum {
	
};

void
BASIC_OP_ARG_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	BASIC_OP_ARG * ins = (BASIC_OP_ARG *)Instance;
	switch(Port) {

		default:
			break;
	}
}

LADSPA_Handle
FILTER_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	FILTER * i = new FILTER;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum FILTER_port_enum {
	FILTER_out_enum, FILTER_in_enum, FILTER_nb_enum, FILTER_na_enum, FILTER_coeffs_enum, 
};

void
FILTER_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	FILTER * ins = (FILTER *)Instance;
	switch(Port) {

		case FILTER_out_enum:
			ins->out = DataLocation;
			break;

		case FILTER_in_enum:
			ins->in = DataLocation;
			break;

		case FILTER_nb_enum:
			ins->nb = DataLocation;
			break;

		case FILTER_na_enum:
			ins->na = DataLocation;
			break;

		case FILTER_coeffs_enum:
			ins->coeffs = DataLocation;
			break;

		default:
			break;
	}
}

void
filter2_activate(LADSPA_Handle Instance)
{
	FILTER * ins = (FILTER *)Instance;
	ifilter(ins);
}

void
filter2_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	FILTER * ins = (FILTER *)Instance;
	set_qcs_controlrate(SampleCount);
	afilter(ins);
}

void
filter2_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_filter2_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "filter2";
	d->Name = "filter2";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 5;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="out";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_AUDIO | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="in";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[2]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[2]="nb";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[2].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[3]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[3]="na";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[3].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[4]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[4]="coeffs";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[4].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = FILTER_instantiate;
	d->connect_port = FILTER_connect_port;
	d->activate = filter2_activate;
	d->run = filter2_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = filter2_cleanup;
	return d;
}

void
zfilter2_activate(LADSPA_Handle Instance)
{
	ZFILTER * ins = (ZFILTER *)Instance;
	izfilter(ins);
}

void
zfilter2_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	ZFILTER * ins = (ZFILTER *)Instance;
	set_qcs_controlrate(SampleCount);
	azfilter(ins);
}

void
zfilter2_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_zfilter2_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "zfilter2";
	d->Name = "zfilter2";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 7;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="out";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_AUDIO | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="in";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[2]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[2]="kmagf";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[2].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[3]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[3]="kphsf";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[3].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[4]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[4]="nb";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[4].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[5]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[5]="na";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[5].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[6]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[6]="coeffs";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[6].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = ZFILTER_instantiate;
	d->connect_port = ZFILTER_connect_port;
	d->activate = zfilter2_activate;
	d->run = zfilter2_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = zfilter2_cleanup;
	return d;
}

enum descriptor_enum {
	filter2_desc_enum, zfilter2_desc_enum, 
};

const LADSPA_Descriptor *
ladspa_descriptor(unsigned long Index)
{
	static bool inited=false;
	static LADSPA_Descriptor *filter2_desc_pointer;
	static LADSPA_Descriptor *zfilter2_desc_pointer;

	if (!inited) {
		filter2_desc_pointer = new_filter2_desc();
		zfilter2_desc_pointer = new_zfilter2_desc();

		inited=true;
	}
	
	switch(Index) {
		case filter2_desc_enum : return filter2_desc_pointer;
		case zfilter2_desc_enum : return zfilter2_desc_pointer;

		default:
			return 0;
	}
}
