
#include "ladspa.h"

extern
void
set_qcs_framerate(unsigned long framerate);

extern
void
set_qcs_controlrate(unsigned long samplecount);
#include "fileops.h"


LADSPA_Handle
FILECLOSE_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	FILECLOSE * i = new FILECLOSE;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum FILECLOSE_port_enum {
	FILECLOSE_file_index_enum, 
};

void
FILECLOSE_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	FILECLOSE * ins = (FILECLOSE *)Instance;
	switch(Port) {

		case FILECLOSE_file_index_enum:
			ins->file_index = DataLocation;
			break;

		default:
			break;
	}
}

LADSPA_Handle
BASIC_OP_ARG_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	BASIC_OP_ARG * i = new BASIC_OP_ARG;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum BASIC_OP_ARG_port_enum {
	
};

void
BASIC_OP_ARG_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	BASIC_OP_ARG * ins = (BASIC_OP_ARG *)Instance;
	switch(Port) {

		default:
			break;
	}
}

LADSPA_Handle
FILEOPEN_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	FILEOPEN * i = new FILEOPEN;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum FILEOPEN_port_enum {
	FILEOPEN_file_index_enum, FILEOPEN_path_enum, FILEOPEN_mode_enum, 
};

void
FILEOPEN_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	FILEOPEN * ins = (FILEOPEN *)Instance;
	switch(Port) {

		case FILEOPEN_file_index_enum:
			ins->file_index = DataLocation;
			break;

		case FILEOPEN_path_enum:
			ins->path = DataLocation;
			break;

		case FILEOPEN_mode_enum:
			ins->mode = DataLocation;
			break;

		default:
			break;
	}
}

LADSPA_Handle
FILETRUNCATE_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	FILETRUNCATE * i = new FILETRUNCATE;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum FILETRUNCATE_port_enum {
	FILETRUNCATE_file_index_enum, FILETRUNCATE_new_size_enum, 
};

void
FILETRUNCATE_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	FILETRUNCATE * ins = (FILETRUNCATE *)Instance;
	switch(Port) {

		case FILETRUNCATE_file_index_enum:
			ins->file_index = DataLocation;
			break;

		case FILETRUNCATE_new_size_enum:
			ins->new_size = DataLocation;
			break;

		default:
			break;
	}
}

LADSPA_Handle
FILETMP_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	FILETMP * i = new FILETMP;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum FILETMP_port_enum {
	FILETMP_file_index_enum, 
};

void
FILETMP_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	FILETMP * ins = (FILETMP *)Instance;
	switch(Port) {

		case FILETMP_file_index_enum:
			ins->file_index = DataLocation;
			break;

		default:
			break;
	}
}

LADSPA_Handle
FILEIO_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	FILEIO * i = new FILEIO;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum FILEIO_port_enum {
	FILEIO_file_index_enum, FILEIO_data_enum, 
};

void
FILEIO_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	FILEIO * ins = (FILEIO *)Instance;
	switch(Port) {

		case FILEIO_file_index_enum:
			ins->file_index = DataLocation;
			break;

		case FILEIO_data_enum:
			ins->data = DataLocation;
			break;

		default:
			break;
	}
}

LADSPA_Handle
FILESEEK_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	FILESEEK * i = new FILESEEK;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum FILESEEK_port_enum {
	FILESEEK_file_index_enum, FILESEEK_position_enum, FILESEEK_whence_enum, 
};

void
FILESEEK_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	FILESEEK * ins = (FILESEEK *)Instance;
	switch(Port) {

		case FILESEEK_file_index_enum:
			ins->file_index = DataLocation;
			break;

		case FILESEEK_position_enum:
			ins->position = DataLocation;
			break;

		case FILESEEK_whence_enum:
			ins->whence = DataLocation;
			break;

		default:
			break;
	}
}

LADSPA_Handle
FILEMISC_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	FILEMISC * i = new FILEMISC;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum FILEMISC_port_enum {
	FILEMISC_result_enum, FILEMISC_file_index_enum, 
};

void
FILEMISC_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	FILEMISC * ins = (FILEMISC *)Instance;
	switch(Port) {

		case FILEMISC_result_enum:
			ins->result = DataLocation;
			break;

		case FILEMISC_file_index_enum:
			ins->file_index = DataLocation;
			break;

		default:
			break;
	}
}

void
fread_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	FILEIO * ins = (FILEIO *)Instance;
	set_qcs_controlrate(SampleCount);
	fileread(ins);
}

void
fread_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_fread_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "fread";
	d->Name = "fread";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 2;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[0]="file_index";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="data";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = FILEIO_instantiate;
	d->connect_port = FILEIO_connect_port;
	d->activate = 0;
	d->run = fread_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = fread_cleanup;
	return d;
}

void
fwrite_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	FILEIO * ins = (FILEIO *)Instance;
	set_qcs_controlrate(SampleCount);
	filewrite(ins);
}

void
fwrite_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_fwrite_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "fwrite";
	d->Name = "fwrite";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 2;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[0]="file_index";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="data";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = FILEIO_instantiate;
	d->connect_port = FILEIO_connect_port;
	d->activate = 0;
	d->run = fwrite_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = fwrite_cleanup;
	return d;
}

enum descriptor_enum {
	fread_desc_enum, fwrite_desc_enum, 
};

const LADSPA_Descriptor *
ladspa_descriptor(unsigned long Index)
{
	static bool inited=false;
	static LADSPA_Descriptor *fread_desc_pointer;
	static LADSPA_Descriptor *fwrite_desc_pointer;

	if (!inited) {
		fread_desc_pointer = new_fread_desc();
		fwrite_desc_pointer = new_fwrite_desc();

		inited=true;
	}
	
	switch(Index) {
		case fread_desc_enum : return fread_desc_pointer;
		case fwrite_desc_enum : return fwrite_desc_pointer;

		default:
			return 0;
	}
}
